/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.nodes.Node;

class ReusablePropertyModel
implements ExPropertyModel {
    private transient Node.Property PROPERTY = null;
    static final boolean DEBUG = Boolean.getBoolean("netbeans.reusable.strictthreads");
    private final ReusablePropertyEnv env;

    public ReusablePropertyModel(ReusablePropertyEnv env) {
        this.env = env;
        env.setReusablePropertyModel(this);
    }

    void clear() {
        this.PROPERTY = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public PropertyEditor getPropertyEditor() {
        return PropUtils.getPropertyEditor(this.getProperty());
    }

    public Class getPropertyEditorClass() {
        if (DEBUG) {
            ReusablePropertyModel.checkThread();
        }
        return this.getPropertyEditor().getClass();
    }

    public Class getPropertyType() {
        if (DEBUG) {
            ReusablePropertyModel.checkThread();
        }
        return this.getProperty().getValueType();
    }

    public Object getValue() throws InvocationTargetException {
        if (DEBUG) {
            ReusablePropertyModel.checkThread();
        }
        try {
            return this.getProperty().getValue();
        }
        catch (IllegalAccessException iae) {
            ErrorManager.getDefault().notify(iae);
            return null;
        }
    }

    public void setValue(Object v) throws InvocationTargetException {
        if (DEBUG) {
            ReusablePropertyModel.checkThread();
        }
        try {
            this.getProperty().setValue(v);
        }
        catch (IllegalAccessException iae) {
            ErrorManager.getDefault().notify(iae);
        }
    }

    public Object[] getBeans() {
        if (DEBUG) {
            ReusablePropertyModel.checkThread();
        }
        if (this.env.getNode() instanceof ProxyNode) {
            return ((ProxyNode)this.env.getNode()).getOriginalNodes();
        }
        return new Object[]{this.env.getNode()};
    }

    public FeatureDescriptor getFeatureDescriptor() {
        if (DEBUG) {
            ReusablePropertyModel.checkThread();
        }
        return this.getProperty();
    }

    static void checkThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Reusable property model accessed from off the AWT thread.");
        }
    }

    public Node.Property getProperty() {
        return this.PROPERTY;
    }

    public void setProperty(Node.Property PROPERTY) {
        this.PROPERTY = PROPERTY;
    }
}

