/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDragSupport;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Node;

final class TreeViewDragSupport
extends ExplorerDragSupport {
    protected TreeView view;
    private JTree tree;

    public TreeViewDragSupport(TreeView view, JTree tree) {
        this.view = view;
        this.comp = tree;
        this.tree = tree;
    }

    public int getAllowedDragActions() {
        return this.view.getAllowedDragActions();
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        TreeCellEditor tce;
        super.dragGestureRecognized(dge);
        if (this.exDnD.isDnDActive() && (tce = this.tree.getCellEditor()) instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)tce).setDnDActive(true);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        Node[] dropedNodes = this.exDnD.getDraggedNodes();
        super.dragDropEnd(dsde);
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
            this.exDnD.setDnDActive(false);
        }
        try {
            ExplorerManager.Provider panel;
            if (dropedNodes != null && (panel = (ExplorerManager.Provider)((Object)SwingUtilities.getAncestorOfClass(ExplorerManager.Provider.class, this.view))) != null) {
                panel.getExplorerManager().setSelectedNodes(dropedNodes);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        TreeCellEditor tce = this.tree.getCellEditor();
        if (tce instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)tce).setDnDActive(false);
        }
    }

    Node[] obtainNodes(DragGestureEvent dge) {
        TreePath[] tps = this.tree.getSelectionPaths();
        if (tps == null) {
            return null;
        }
        Node[] result = new Node[tps.length];
        int cnt = 0;
        for (int i = 0; i < tps.length; ++i) {
            if (this.tree.getPathBounds(tps[i]).contains(dge.getDragOrigin())) {
                ++cnt;
            }
            result[i] = DragDropUtilities.secureFindNode(tps[i].getLastPathComponent());
        }
        return cnt == 0 ? null : result;
    }
}

