/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.ErrorManager;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;

public abstract class Children {
    static final Mutex.Privileged PR = new Mutex.Privileged();
    public static final Mutex MUTEX = new Mutex(PR);
    public static final Children LEAF = new Empty();
    private Node parent;
    private java.util.Map map;
    private Collection entries = Collections.EMPTY_LIST;
    Reference array = new WeakReference<Object>(null);
    private static final Object LOCK = new Object();
    private static final ErrorManager LOG_GET_ARRAY = ErrorManager.getDefault().getInstance("org.openide.nodes.Children.getArray");
    private static final boolean IS_LOG_GET_ARRAY = LOG_GET_ARRAY.isLoggable(1);
    private Thread initThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void attachTo(Node n) throws IllegalStateException {
        if (this == LEAF) {
            return;
        }
        Children children = this;
        synchronized (children) {
            if (this.parent != null) {
                throw new IllegalStateException("An instance of Children may not be used for more than one parent node.");
            }
            this.parent = n;
        }
        try {
            PR.enterReadAccess();
            Node[] nodes = this.testNodes();
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                node.assignTo(this, i);
                node.fireParentNodeChange(null, this.parent);
            }
        }
        finally {
            PR.exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void detachFrom() {
        if (this == LEAF) {
            return;
        }
        Node oldParent = null;
        Children children = this;
        synchronized (children) {
            if (this.parent == null) {
                throw new IllegalStateException("Trying to detach children which do not have parent");
            }
            oldParent = this.parent;
            this.parent = null;
        }
        try {
            PR.enterReadAccess();
            Node[] nodes = this.testNodes();
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                node.deassignFrom(this);
                node.fireParentNodeChange(oldParent, null);
            }
        }
        finally {
            PR.exitReadAccess();
        }
    }

    protected final Node getNode() {
        return this.parent;
    }

    final Object cloneHierarchy() throws CloneNotSupportedException {
        return this.clone();
    }

    protected Object clone() throws CloneNotSupportedException {
        Children ch = (Children)super.clone();
        ch.parent = null;
        ch.map = null;
        ch.entries = Collections.EMPTY_LIST;
        ch.array = new WeakReference<Object>(null);
        return ch;
    }

    public abstract boolean add(Node[] var1);

    public abstract boolean remove(Node[] var1);

    public final Enumeration nodes() {
        return Enumerations.array(this.getNodes());
    }

    public Node findChild(String name) {
        Node[] list = this.getNodes();
        if (list.length == 0) {
            return null;
        }
        if (name == null) {
            return list[0];
        }
        for (int i = 0; i < list.length; ++i) {
            if (!name.equals(list[i].getName())) continue;
            return list[i];
        }
        return null;
    }

    protected final boolean isInitialized() {
        ChildrenArray arr = (ChildrenArray)this.array.get();
        return arr != null && arr.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node[] getNodes() {
        Node[] nodes;
        boolean[] results = new boolean[2];
        do {
            results[1] = this.isInitialized();
            ChildrenArray array = this.getArray(results);
            try {
                PR.enterReadAccess();
                nodes = array.nodes();
            }
            finally {
                PR.exitReadAccess();
            }
            if (!results[1]) continue;
            return nodes;
        } while (!results[0]);
        return nodes == null ? new Node[]{} : nodes;
    }

    public Node[] getNodes(boolean optimalResult) {
        if (optimalResult) {
            ChildrenArray arr = this.getArray(null);
            this.findChild(null);
        }
        return this.getNodes();
    }

    public final int getNodesCount() {
        return this.getNodes().length;
    }

    protected void addNotify() {
    }

    protected void removeNotify() {
    }

    void callAddNotify() {
        this.addNotify();
    }

    private Node[] testNodes() {
        ChildrenArray arr = (ChildrenArray)this.array.get();
        return arr == null ? null : arr.nodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChildrenArray getArray(boolean[] cannotWorkBetter) {
        ChildrenArray arr;
        block32: {
            Object object;
            block31: {
                boolean notifyLater2;
                Object object2;
                boolean doInitialize = false;
                object = LOCK;
                synchronized (object) {
                    arr = (ChildrenArray)this.array.get();
                    if (arr == null) {
                        arr = new ChildrenArray();
                        this.registerChildrenArray(arr, true);
                        doInitialize = true;
                        this.initThread = Thread.currentThread();
                    }
                }
                if (!doInitialize) break block31;
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.log("Initialize " + this + " on " + Thread.currentThread());
                }
                try {
                    this.callAddNotify();
                    if (IS_LOG_GET_ARRAY) {
                        LOG_GET_ARRAY.log("addNotify successfully called for " + this + " on " + Thread.currentThread());
                    }
                    Object var7_7 = null;
                    if (IS_LOG_GET_ARRAY) {
                        LOG_GET_ARRAY.log("notifyAll for " + this + " on " + Thread.currentThread());
                    }
                    object2 = LOCK;
                }
                catch (Throwable throwable) {
                    boolean notifyLater2;
                    Object var7_8 = null;
                    if (IS_LOG_GET_ARRAY) {
                        LOG_GET_ARRAY.log("notifyAll for " + this + " on " + Thread.currentThread());
                    }
                    Object object3 = LOCK;
                    synchronized (object3) {
                        arr.children = this;
                        this.initThread = null;
                        notifyLater2 = MUTEX.isReadAccess();
                        if (!notifyLater2) {
                            LOCK.notifyAll();
                        }
                    }
                    if (notifyLater2) {
                        MUTEX.postWriteRequest(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Object object = LOCK;
                                synchronized (object) {
                                    LOCK.notifyAll();
                                }
                            }
                        });
                    }
                    throw throwable;
                }
                synchronized (object2) {
                    arr.children = this;
                    this.initThread = null;
                    notifyLater2 = MUTEX.isReadAccess();
                    if (!notifyLater2) {
                        LOCK.notifyAll();
                    }
                }
                if (notifyLater2) {
                    MUTEX.postWriteRequest(new /* invalid duplicate definition of identical inner class */);
                }
                break block32;
            }
            if (MUTEX.isReadAccess() || this.initThread == Thread.currentThread()) {
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.log("cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + MUTEX.isReadAccess() + " initThread: " + this.initThread);
                }
                if (cannotWorkBetter != null) {
                    cannotWorkBetter[0] = true;
                }
                return arr;
            }
            object = LOCK;
            synchronized (object) {
                while (arr.children == null) {
                    if (IS_LOG_GET_ARRAY) {
                        LOG_GET_ARRAY.log("waiting for children for " + this + " on " + Thread.currentThread());
                    }
                    try {
                        LOCK.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                if (IS_LOG_GET_ARRAY) {
                    LOG_GET_ARRAY.log(" children are here for " + this + " on " + Thread.currentThread() + " children " + arr.children);
                }
            }
        }
        return arr;
    }

    private void clearNodes() {
        ChildrenArray arr = (ChildrenArray)this.array.get();
        if (arr != null) {
            arr.clear();
        }
    }

    final void finalizeNodes() {
        ChildrenArray arr = (ChildrenArray)this.array.get();
        if (arr != null) {
            arr.finalizeNodes();
        }
    }

    final void registerChildrenArray(final ChildrenArray array, boolean weak) {
        this.array = weak ? new WeakReference<ChildrenArray>(array) : new WeakReference(array){

            public Object get() {
                return array;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finalizedChildrenArray(Object caller) {
        try {
            PR.enterWriteAccess();
            Object value = this.array.get();
            if (value == null || value == caller) {
                this.removeNotify();
            }
        }
        finally {
            PR.exitWriteAccess();
        }
    }

    final Node[] justComputeNodes() {
        if (this.map == null) {
            this.map = new HashMap(17);
        }
        LinkedList l = new LinkedList();
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            Info info = this.findInfo(entry);
            try {
                l.addAll(info.nodes());
            }
            catch (RuntimeException ex) {
                NodeOp.warning(ex);
            }
        }
        Node[] arr = l.toArray(new Node[l.size()]);
        for (int i = 0; i < arr.length; ++i) {
            Node n = arr[i];
            n.assignTo(this, i);
            n.fireParentNodeChange(null, this.parent);
        }
        return arr;
    }

    private Info findInfo(Entry entry) {
        Info info = (Info)this.map.get(entry);
        if (info == null) {
            info = new Info(entry);
            this.map.put(entry, info);
        }
        return info;
    }

    final ArrayList getEntries() {
        return new ArrayList(this.entries);
    }

    final void setEntries(Collection entries) {
        List toAdd;
        ChildrenArray holder = (ChildrenArray)this.array.get();
        if (IS_LOG_GET_ARRAY) {
            LOG_GET_ARRAY.log("setEntries for " + this + " on " + Thread.currentThread());
            LOG_GET_ARRAY.log("       values: " + entries);
            LOG_GET_ARRAY.log("       holder: " + holder);
        }
        if (holder == null) {
            this.entries = entries;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet(entries));
            }
            return;
        }
        Node[] current = holder.nodes();
        if (current == null) {
            this.entries = entries;
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet(entries));
            }
            return;
        }
        this.map.keySet().retainAll(new HashSet(this.entries));
        HashSet toRemove = new HashSet(this.map.keySet());
        HashSet entriesSet = new HashSet(entries);
        toRemove.removeAll(entriesSet);
        if (!toRemove.isEmpty()) {
            this.updateRemove(current, toRemove);
            current = holder.nodes();
        }
        if (!(toAdd = this.updateOrder(current, entries)).isEmpty()) {
            this.updateAdd(toAdd, entries);
        }
    }

    private void updateRemove(Node[] current, Set toRemove) {
        LinkedList nodes = new LinkedList();
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            Entry en = (Entry)it.next();
            Info info = (Info)this.map.remove(en);
            nodes.addAll(info.nodes());
        }
        this.entries.removeAll(toRemove);
        this.clearNodes();
        this.notifyRemove(nodes, current);
    }

    Node[] notifyRemove(Collection nodes, Node[] current) {
        Node[] arr = nodes.toArray(new Node[nodes.size()]);
        if (this.parent == null) {
            return arr;
        }
        this.parent.fireSubNodesChange(false, arr, current);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.deassignFrom(this);
            n.fireParentNodeChange(this.parent, null);
        }
        return arr;
    }

    private List updateOrder(Node[] current, Collection entries) {
        LinkedList<Info> toAdd = new LinkedList<Info>();
        HashMap<Info, Integer> offsets = new HashMap<Info, Integer>();
        int previousPos = 0;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            Info info = (Info)this.map.get(entry);
            if (info == null) {
                throw new IllegalStateException("Error in " + this.getClass().getName() + " with entry " + entry + " probably caused by faulty key implementation." + " The key hashCode() and equals() methods must behave as for an IMMUTABLE object" + " and the hashCode() must return the same value for equals() keys.");
            }
            offsets.put(info, new Integer(previousPos));
            previousPos += info.length();
        }
        this.map.keySet().retainAll(new HashSet(this.entries));
        int[] perm = new int[current.length];
        int currentPos = 0;
        int permSize = 0;
        LinkedList<Entry> reorderedEntries = null;
        Iterator it2 = entries.iterator();
        while (it2.hasNext()) {
            Entry entry = (Entry)it2.next();
            Info info = (Info)this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                toAdd.add(info);
            } else {
                int len = info.length();
                if (reorderedEntries == null) {
                    reorderedEntries = new LinkedList<Entry>();
                }
                reorderedEntries.add(entry);
                Integer previousInt = (Integer)offsets.get(info);
                int previousPos2 = previousInt;
                if (currentPos != previousPos2) {
                    for (int i = 0; i < len; ++i) {
                        perm[previousPos2 + i] = 1 + currentPos + i;
                    }
                    permSize += len;
                }
            }
            currentPos += info.length();
        }
        if (permSize > 0) {
            for (int i = 0; i < perm.length; ++i) {
                if (perm[i] == 0) {
                    perm[i] = i;
                    continue;
                }
                int n = i;
                perm[n] = perm[n] - 1;
            }
            this.entries = reorderedEntries;
            this.clearNodes();
            Node p = this.parent;
            if (p != null) {
                p.fireReorderChange(perm);
            }
        }
        return toAdd;
    }

    private void updateAdd(Collection infos, Collection entries) {
        LinkedList nodes = new LinkedList();
        Iterator it = infos.iterator();
        while (it.hasNext()) {
            Info info = (Info)it.next();
            nodes.addAll(info.nodes());
            this.map.put(info.entry, info);
        }
        this.entries = entries;
        this.clearNodes();
        this.notifyAdd(nodes);
    }

    private void notifyAdd(Collection nodes) {
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.assignTo(this, -1);
            n.fireParentNodeChange(null, this.parent);
        }
        Node[] arr = nodes.toArray(new Node[nodes.size()]);
        Node n = this.parent;
        if (n != null) {
            n.fireSubNodesChange(true, arr, null);
        }
    }

    final void refreshEntry(Entry entry) {
        Collection newNodes;
        ChildrenArray holder = (ChildrenArray)this.array.get();
        if (holder == null) {
            return;
        }
        Node[] current = holder.nodes();
        if (current == null) {
            return;
        }
        this.map.keySet().retainAll(new HashSet(this.entries));
        Info info = (Info)this.map.get(entry);
        if (info == null) {
            return;
        }
        Collection oldNodes = info.nodes();
        if (((Object)oldNodes).equals(newNodes = info.entry.nodes())) {
            return;
        }
        HashSet toRemove = new HashSet(oldNodes);
        toRemove.removeAll(newNodes);
        if (!toRemove.isEmpty()) {
            oldNodes.removeAll(toRemove);
            this.clearNodes();
            this.notifyRemove(toRemove, current);
            current = holder.nodes();
        }
        List toAdd = this.refreshOrder(entry, oldNodes, newNodes);
        info.useNodes(newNodes);
        if (!toAdd.isEmpty()) {
            this.clearNodes();
            this.notifyAdd(toAdd);
        }
    }

    private List refreshOrder(Entry entry, Collection oldNodes, Collection newNodes) {
        Entry e;
        LinkedList<Node> toAdd = new LinkedList<Node>();
        int currentPos = 0;
        Iterator it = this.entries.iterator();
        while (!(e = (Entry)it.next()).equals(entry)) {
            Info info = this.findInfo(e);
            currentPos += info.length();
        }
        HashSet oldNodesSet = new HashSet(oldNodes);
        HashSet toProcess = (HashSet)oldNodesSet.clone();
        Node[] permArray = new Node[oldNodes.size()];
        it = newNodes.iterator();
        int pos = 0;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (oldNodesSet.remove(n)) {
                permArray[pos++] = n;
                continue;
            }
            if (!toProcess.contains(n)) {
                toAdd.add(n);
                continue;
            }
            it.remove();
        }
        int[] perm = NodeOp.computePermutation(oldNodes.toArray(new Node[oldNodes.size()]), permArray);
        if (perm != null) {
            this.clearNodes();
            this.findInfo(entry).useNodes(Arrays.asList(permArray));
            Node p = this.parent;
            if (p != null) {
                p.fireReorderChange(perm);
            }
        }
        return toAdd;
    }

    private static class Dupl
    implements Cloneable {
        protected Object key;

        Dupl() {
        }

        public final void updateList(Collection src, Collection target) {
            HashMap map = new HashMap(src.size() * 2);
            Iterator it = src.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                this.updateListAndMap(o, target, map);
            }
        }

        public final void updateList(Object[] arr, Collection target) {
            HashMap map = new HashMap(arr.length * 2);
            for (int i = 0; i < arr.length; ++i) {
                this.updateListAndMap(arr[i], target, map);
            }
        }

        public final void updateListAndMap(Object obj, Collection list, java.util.Map map) {
            Dupl prev = map.put(obj, this);
            if (prev == null) {
                list.add(this.createInstance(obj, 0));
                return;
            }
            if (prev == this) {
                map.put(obj, new Integer(1));
                list.add(this.createInstance(obj, 1));
                return;
            }
            int cnt = (Integer)((Object)prev) + 1;
            map.put(obj, new Integer(cnt));
            list.add(this.createInstance(obj, cnt));
        }

        public final Object getKey() {
            if (this.key instanceof Dupl) {
                return ((Dupl)this.key).getKey();
            }
            return this.key;
        }

        public final int getCnt() {
            int cnt = 0;
            Dupl d = this;
            while (d.key instanceof Dupl) {
                d = (Dupl)d.key;
                ++cnt;
            }
            return cnt;
        }

        private final Dupl createInstance(Object obj, int cnt) {
            try {
                Dupl d;
                Dupl first = d = (Dupl)this.clone();
                while (cnt-- > 0) {
                    Dupl n = (Dupl)this.clone();
                    d.key = n;
                    d = n;
                }
                d.key = obj;
                return first;
            }
            catch (CloneNotSupportedException ex) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Dupl) {
                Dupl d = (Dupl)o;
                return this.getKey().equals(d.getKey()) && this.getCnt() == d.getCnt();
            }
            return false;
        }

        public String toString() {
            String s = this.getKey().toString();
            if (s.length() > 80) {
                s = s.substring(0, 80);
            }
            return "Key (" + s + ", " + this.getCnt() + ")";
        }
    }

    public static abstract class Keys
    extends Array {
        private boolean before;
        private static HashMap lastRuns = new HashMap(11);

        public Object clone() {
            Keys k = (Keys)super.clone();
            return k;
        }

        public boolean add(Node[] arr) {
            return super.add(arr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Node[] arr) {
            try {
                PR.enterWriteAccess();
                if (this.nodes != null) {
                    for (int i = 0; i < arr.length; ++i) {
                        if (this.nodes.contains(arr[i])) continue;
                        arr[i] = null;
                    }
                    this.superRemove(arr);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
            return true;
        }

        final void superRemove(Node[] arr) {
            super.remove(arr);
        }

        protected final void refreshKey(Object key) {
            MUTEX.postWriteRequest(new Runnable(this, key){
                private final /* synthetic */ Object val$key;
                private final /* synthetic */ Keys this$0;
                {
                    this.this$0 = this$0;
                    this.val$key = val$key;
                }

                public void run() {
                    this.this$0.refreshEntry(this.this$0.new KE(this.val$key));
                }
            });
        }

        protected final void setKeys(Collection keysSet) {
            ArrayList<Entry> l = new ArrayList<Entry>(keysSet.size() + 1);
            if (this.before) {
                l.add(this.getNodesEntry());
            }
            KE updator = new KE();
            updator.updateList(keysSet, l);
            if (!this.before) {
                l.add(this.getNodesEntry());
            }
            this.applyKeys(l);
        }

        protected final void setKeys(Object[] keys) {
            ArrayList<Entry> l = new ArrayList<Entry>(keys.length + 1);
            KE updator = new KE();
            if (this.before) {
                l.add(this.getNodesEntry());
            }
            updator.updateList(keys, l);
            if (!this.before) {
                l.add(this.getNodesEntry());
            }
            this.applyKeys(l);
        }

        private void applyKeys(ArrayList l) {
            Runnable invoke = new Runnable(this, l){
                private final /* synthetic */ ArrayList val$l;
                private final /* synthetic */ Keys this$0;
                {
                    this.this$0 = this$0;
                    this.val$l = val$l;
                }

                public void run() {
                    if (Keys.access$500(this.this$0, this)) {
                        this.this$0.setEntries(this.val$l);
                        Keys.access$600(this.this$0, this);
                    }
                }
            };
            Keys.keysEnter(this, invoke);
            MUTEX.postWriteRequest(invoke);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void setBefore(boolean b) {
            try {
                PR.enterWriteAccess();
                if (this.before != b) {
                    ArrayList l = this.getEntries();
                    l.remove(this.getNodesEntry());
                    this.before = b;
                    if (b) {
                        l.add(0, this.getNodesEntry());
                    } else {
                        l.add(this.getNodesEntry());
                    }
                    this.setEntries(l);
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected abstract Node[] createNodes(Object var1);

        protected void destroyNodes(Node[] arr) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i].fireNodeDestroyed();
            }
        }

        Node[] notifyRemove(Collection nodes, Node[] current) {
            Node[] arr = super.notifyRemove(nodes, current);
            this.destroyNodes(arr);
            return arr;
        }

        private static synchronized void keysEnter(Keys ch, Runnable run) {
            lastRuns.put(ch, run);
        }

        private static synchronized void keysExit(Keys ch, Runnable r) {
            Runnable reg = (Runnable)lastRuns.remove(ch);
            if (reg != null && !reg.equals(r)) {
                lastRuns.put(ch, reg);
            }
        }

        private static synchronized boolean keysCheck(Keys ch, Runnable run) {
            return run == lastRuns.get(ch);
        }

        static /* synthetic */ boolean access$500(Keys x0, Runnable x1) {
            return Keys.keysCheck(x0, x1);
        }

        static /* synthetic */ void access$600(Keys x0, Runnable x1) {
            Keys.keysExit(x0, x1);
        }

        private final class KE
        extends Dupl
        implements Entry {
            public KE() {
            }

            public KE(Object key) {
                this.key = key;
            }

            public Collection nodes() {
                Node[] arr = Keys.this.createNodes(this.getKey());
                if (arr == null) {
                    return Collections.EMPTY_LIST;
                }
                return new LinkedList<Node>(Arrays.asList(arr));
            }
        }
    }

    public static class SortedMap
    extends Map {
        private Comparator comp;

        public SortedMap() {
        }

        protected SortedMap(java.util.Map map) {
            super(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator c) {
            try {
                PR.enterWriteAccess();
                this.comp = c;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator getComparator() {
            return this.comp;
        }

        Collection createEntries(java.util.Map map) {
            TreeSet<Map.ME> l = new TreeSet<Map.ME>(new SMComparator());
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                l.add(new Map.ME(e.getKey(), (Node)e.getValue()));
            }
            return l;
        }

        final class SMComparator
        implements Comparator {
            SMComparator() {
            }

            public int compare(Object o1, Object o2) {
                Map.ME me1 = (Map.ME)o1;
                Map.ME me2 = (Map.ME)o2;
                Comparator c = SortedMap.this.comp;
                if (c == null) {
                    return ((Comparable)me1.key).compareTo(me2.key);
                }
                return c.compare(me1.node, me2.node);
            }
        }
    }

    public static class SortedArray
    extends Array {
        private Comparator comp;

        public SortedArray() {
        }

        protected SortedArray(Collection c) {
            super(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComparator(Comparator c) {
            try {
                PR.enterWriteAccess();
                this.comp = c;
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        public Comparator getComparator() {
            return this.comp;
        }

        Entry createNodesEntry() {
            return new SAE();
        }

        private final class SAE
        implements Entry {
            public Collection nodes() {
                ArrayList al = new ArrayList(SortedArray.this.getCollection());
                Collections.sort(al, SortedArray.this.comp);
                return al;
            }
        }
    }

    public static class Map
    extends Children {
        protected java.util.Map nodes;

        protected Map(java.util.Map m) {
            this.nodes = m;
        }

        public Map() {
        }

        final java.util.Map getMap() {
            if (this.nodes == null) {
                this.nodes = this.initMap();
            }
            return this.nodes;
        }

        final void callAddNotify() {
            this.setEntries(this.createEntries(this.getMap()));
            super.callAddNotify();
        }

        Collection createEntries(java.util.Map map) {
            LinkedList<ME> l = new LinkedList<ME>();
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                l.add(new ME(e.getKey(), (Node)e.getValue()));
            }
            return l;
        }

        final void refreshImpl() {
            this.setEntries(this.createEntries(this.getMap()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refresh() {
            try {
                PR.enterWriteAccess();
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        final void refreshKeyImpl(Object key) {
            this.refreshEntry(new ME(key, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void refreshKey(Object key) {
            try {
                PR.enterWriteAccess();
                this.refreshKeyImpl(key);
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void putAll(java.util.Map map) {
            try {
                PR.enterWriteAccess();
                this.nodes.putAll(map);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void put(Object key, Node node) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.put(key, node) != null) {
                    this.refreshKeyImpl(key);
                } else {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void removeAll(Collection keys) {
            try {
                PR.enterWriteAccess();
                this.nodes.keySet().removeAll(keys);
                this.refreshImpl();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(Object key) {
            try {
                PR.enterWriteAccess();
                if (this.nodes.remove(key) != null) {
                    this.refreshImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        protected java.util.Map initMap() {
            return new HashMap(7);
        }

        public boolean add(Node[] arr) {
            return false;
        }

        public boolean remove(Node[] arr) {
            return false;
        }

        static final class ME
        implements Entry {
            public Object key;
            public Node node;

            public ME(Object key, Node node) {
                this.key = key;
                this.node = node;
            }

            public Collection nodes() {
                return Collections.singleton(this.node);
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof ME) {
                    ME me = (ME)o;
                    return this.key.equals(me.key);
                }
                return false;
            }

            public String toString() {
                return "Key (" + this.key + ")";
            }
        }
    }

    public static class Array
    extends Children
    implements Cloneable {
        private Entry nodesEntry = this.createNodesEntry();
        protected Collection nodes;

        protected Array(Collection c) {
            this();
            this.nodes = c;
        }

        public Array() {
            this.setEntries(Collections.singleton(this.getNodesEntry()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() {
            try {
                Array ar = (Array)super.clone();
                try {
                    PR.enterReadAccess();
                    if (this.nodes != null) {
                        ar.nodes = ar.initCollection();
                        ar.nodes.clear();
                        Iterator it = this.nodes.iterator();
                        while (it.hasNext()) {
                            Node n = (Node)it.next();
                            ar.nodes.add(n.cloneNode());
                        }
                    }
                }
                finally {
                    PR.exitReadAccess();
                }
                return ar;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        protected Collection initCollection() {
            return new ArrayList();
        }

        final void refreshImpl() {
            if (this.isInitialized()) {
                this.refreshEntry(this.getNodesEntry());
                ((Children)this).getArray(null).nodes();
            } else if (this.nodes != null) {
                Iterator it = this.nodes.iterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.assignTo(this, -1);
                }
            }
        }

        protected final void refresh() {
            MUTEX.postWriteRequest(new Runnable(this){
                private final /* synthetic */ Array this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.refreshImpl();
                }
            });
        }

        final Entry getNodesEntry() {
            return this.nodesEntry;
        }

        Entry createNodesEntry() {
            return new AE();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection getCollection() {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (this.nodes == null) {
                    this.nodes = this.initCollection();
                }
            }
            return this.nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Node[] arr) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().addAll(Arrays.asList(arr))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Node[] arr) {
            Entry entry = this.getNodesEntry();
            synchronized (entry) {
                if (!this.getCollection().removeAll(Arrays.asList(arr))) {
                    return false;
                }
            }
            this.refresh();
            return true;
        }

        private final class AE
        implements Entry {
            AE() {
            }

            public Collection nodes() {
                Collection c = Array.this.getCollection();
                if (c.isEmpty()) {
                    return Collections.EMPTY_LIST;
                }
                return new ArrayList(c);
            }
        }
    }

    private static final class Empty
    extends Children {
        Empty() {
        }

        public boolean add(Node[] nodes) {
            return false;
        }

        public boolean remove(Node[] nodes) {
            return false;
        }
    }

    static interface Entry {
        public Collection nodes();
    }

    final class Info {
        int length;
        Entry entry;

        public Info(Entry entry) {
            this.entry = entry;
        }

        protected void finalize() {
            Children.this.finalizeNodes();
        }

        public Collection nodes() {
            ChildrenArray arr = Children.this.getArray(null);
            return arr.nodesFor(this);
        }

        public void useNodes(Collection nodes) {
            ChildrenArray arr = Children.this.getArray(null);
            arr.useNodes(this, nodes);
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                n.assignTo(Children.this, -1);
                n.fireParentNodeChange(null, Children.this.parent);
            }
        }

        public int length() {
            return this.length;
        }
    }
}

