/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.nodes.Node;
import org.openide.util.lookup.AbstractLookup;

public final class CookieSet {
    private static ThreadLocal QUERY_MODE = new ThreadLocal();
    private HashMap map = new HashMap(31);
    private EventListenerList listeners = new EventListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.unregisterCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie ret = null;
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            R r = this.findR(clazz);
            if (r == null) {
                return null;
            }
            ret = r.cookie();
        }
        if (ret instanceof CookieEntry) {
            if (clazz == QUERY_MODE.get()) {
                QUERY_MODE.set(ret);
                ret = null;
            } else {
                ret = ((CookieEntry)ret).getCookie(true);
            }
        }
        return ret;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    static Object entryQueryMode(Class c) {
        Object prev = QUERY_MODE.get();
        QUERY_MODE.set(c);
        return prev;
    }

    static AbstractLookup.Pair exitQueryMode(Object prev) {
        Object cookie = QUERY_MODE.get();
        QUERY_MODE.set(prev);
        if (cookie instanceof CookieEntry) {
            return new CookieEntryPair((CookieEntry)cookie);
        }
        return null;
    }

    private void fireChangeEvent() {
        Object[] arr = this.listeners.getListenerList();
        if (arr.length > 0) {
            ChangeEvent ev = null;
            for (int i = arr.length - 2; i >= 0; i -= 2) {
                if (arr[i] != (class$javax$swing$event$ChangeListener == null ? CookieSet.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (ev == null) {
                    ev = new ChangeEvent(this);
                }
                ((ChangeListener)arr[i + 1]).stateChanged(ev);
            }
        }
    }

    private void registerCookie(Class c, Node.Cookie cookie) {
        if (c == null || !Node.Cookie.class.isAssignableFrom(c)) {
            return;
        }
        R r = this.findR(c);
        if (r == null) {
            r = new R();
            this.map.put(c, r);
        }
        r.add(cookie);
        this.registerCookie(c.getSuperclass(), cookie);
        Class<?>[] inter = c.getInterfaces();
        for (int i = 0; i < inter.length; ++i) {
            this.registerCookie(inter[i], cookie);
        }
    }

    private void unregisterCookie(Class c, Node.Cookie cookie) {
        if (c == null || !Node.Cookie.class.isAssignableFrom(c)) {
            return;
        }
        R r = this.findR(c);
        if (r != null) {
            r.remove(cookie);
        }
        this.unregisterCookie(c.getSuperclass(), cookie);
        Class<?>[] inter = c.getInterfaces();
        for (int i = 0; i < inter.length; ++i) {
            this.unregisterCookie(inter[i], cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(cookieClass, new CookieEntry(factory, cookieClass));
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class[] cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            for (int i = 0; i < cookieClass.length; ++i) {
                this.registerCookie(cookieClass[i], new CookieEntry(factory, cookieClass[i]));
            }
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Class cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            Node.Cookie c;
            R r = this.findR(cookieClass);
            if (r != null && (c = r.cookie()) instanceof CookieEntry) {
                CookieEntry ce = (CookieEntry)c;
                if (ce.factory == factory) {
                    this.unregisterCookie(cookieClass, c);
                }
            }
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Class[] cookieClass, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            for (int i = 0; i < cookieClass.length; ++i) {
                Node.Cookie c;
                R r = this.findR(cookieClass[i]);
                if (r == null || !((c = r.cookie()) instanceof CookieEntry)) continue;
                CookieEntry ce = (CookieEntry)c;
                if (ce.factory != factory) continue;
                this.unregisterCookie(cookieClass[i], c);
            }
        }
        this.fireChangeEvent();
    }

    private R findR(Class c) {
        return (R)this.map.get(c);
    }

    private static Class baseForCookie(Node.Cookie c) {
        if (c instanceof CookieEntry) {
            return ((CookieEntry)c).klass;
        }
        return c.getClass();
    }

    private static final class R {
        public List cookies;
        public Class base;

        R() {
        }

        public void add(Node.Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList(1);
                this.cookies.add(cookie);
                this.base = CookieSet.baseForCookie(cookie);
                return;
            }
            Class newBase = CookieSet.baseForCookie(cookie);
            if (this.base == null || newBase.isAssignableFrom(this.base)) {
                this.cookies.set(0, cookie);
                this.base = newBase;
            } else {
                this.cookies.add(cookie);
            }
        }

        public boolean remove(Node.Cookie cookie) {
            if (this.cookies == null) {
                return true;
            }
            if (this.cookies.remove(cookie) && this.cookies.size() == 0) {
                this.base = null;
                this.cookies = null;
                return true;
            }
            this.base = CookieSet.baseForCookie((Node.Cookie)this.cookies.get(0));
            return false;
        }

        public Node.Cookie cookie() {
            return this.cookies == null || this.cookies.isEmpty() ? null : (Node.Cookie)this.cookies.get(0);
        }
    }

    private static final class CookieEntryPair
    extends AbstractLookup.Pair {
        private CookieEntry entry;

        public CookieEntryPair(CookieEntry e) {
            this.entry = e;
        }

        protected boolean creatorOf(Object obj) {
            return obj == this.entry.getCookie(false);
        }

        public String getDisplayName() {
            return this.getId();
        }

        public String getId() {
            return this.entry.klass.getName();
        }

        public Object getInstance() {
            return this.entry.getCookie(true);
        }

        public Class getType() {
            return this.entry.klass;
        }

        protected boolean instanceOf(Class c) {
            return c.isAssignableFrom(this.entry.klass);
        }

        public int hashCode() {
            return this.entry.hashCode() + 5;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CookieEntryPair) {
                return ((CookieEntryPair)obj).entry == this.entry;
            }
            return false;
        }
    }

    private static class CookieEntry
    implements Node.Cookie {
        final Factory factory;
        private final Class klass;
        private Reference cookie;

        public CookieEntry(Factory factory, Class klass) {
            this.factory = factory;
            this.klass = klass;
        }

        public synchronized Node.Cookie getCookie(boolean create) {
            Node.Cookie ret;
            if (create) {
                if (this.cookie == null || (ret = (Node.Cookie)this.cookie.get()) == null) {
                    ret = this.factory.createCookie(this.klass);
                    if (ret == null) {
                        return null;
                    }
                    this.cookie = new WeakReference<Node.Cookie>(ret);
                }
            } else {
                ret = this.cookie == null ? null : this.cookie.get();
            }
            return ret;
        }
    }

    public static interface Factory {
        public Node.Cookie createCookie(Class var1);
    }
}

