/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.TMUtil;

public interface Index
extends Node.Cookie {
    public int getNodesCount();

    public Node[] getNodes();

    public int indexOf(Node var1);

    public void reorder();

    public void reorder(int[] var1);

    public void move(int var1, int var2);

    public void exchange(int var1, int var2);

    public void moveUp(int var1);

    public void moveDown(int var1);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static abstract class KeysChildren
    extends Children.Keys {
        private Index support;
        protected final List list;

        public KeysChildren(List ar) {
            this.list = ar;
            this.update();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Index getIndex() {
            KeysChildren keysChildren = this;
            synchronized (keysChildren) {
                if (this.support == null) {
                    this.support = this.createIndex();
                }
                return this.support;
            }
        }

        protected Index createIndex() {
            return new Support(this){
                private final /* synthetic */ KeysChildren this$0;
                {
                    this.this$0 = this$0;
                }

                public Node[] getNodes() {
                    List<Node> l = Arrays.asList(this.this$0.getNodes());
                    if (this.this$0.nodes != null) {
                        l.removeAll(this.this$0.nodes);
                    }
                    return l.toArray(new Node[l.size()]);
                }

                public int getNodesCount() {
                    return this.this$0.list.size();
                }

                public void reorder(int[] perm) {
                    this.this$0.reorder(perm);
                    this.this$0.update();
                    this.fireChangeEvent(new ChangeEvent(this));
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reorder(int[] perm) {
            Object object = this.lock();
            synchronized (object) {
                Object[] n = this.list.toArray();
                for (int i = 0; i < n.length; ++i) {
                    this.list.set(perm[i], n[i]);
                }
            }
        }

        protected Object lock() {
            return this.list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void update() {
            Object[] keys;
            Object object = this.lock();
            synchronized (object) {
                keys = this.list.toArray();
            }
            super.setKeys(keys);
        }
    }

    public static class ArrayChildren
    extends Children.Array
    implements Index {
        protected Index support = new Support(this){
            private final /* synthetic */ ArrayChildren this$0;
            {
                this.this$0 = this$0;
            }

            public Node[] getNodes() {
                return this.this$0.getNodes();
            }

            public int getNodesCount() {
                return this.this$0.getNodesCount();
            }

            public void reorder(int[] perm) {
                this.this$0.reorder(perm);
                this.fireChangeEvent(new ChangeEvent(this.this$0));
            }
        };

        public ArrayChildren() {
            this(null);
        }

        private ArrayChildren(List ar) {
            super(ar);
        }

        protected Collection initCollection() {
            return new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder(int[] perm) {
            try {
                PR.enterWriteAccess();
                Object[] n = this.nodes.toArray();
                List l = (List)this.nodes;
                for (int i = 0; i < n.length; ++i) {
                    l.set(perm[i], n[i]);
                }
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder() {
            try {
                PR.enterReadAccess();
                Support.showIndexedCustomizer(this);
            }
            finally {
                PR.exitReadAccess();
            }
        }

        public void move(int x, int y) {
            this.support.move(x, y);
        }

        public void exchange(int x, int y) {
            this.support.exchange(x, y);
        }

        public void moveUp(int x) {
            this.support.exchange(x, x - 1);
        }

        public void moveDown(int x) {
            this.support.exchange(x, x + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Node node) {
            try {
                PR.enterReadAccess();
                int n = ((List)this.nodes).indexOf(node);
                return n;
            }
            finally {
                PR.exitReadAccess();
            }
        }

        public void addChangeListener(ChangeListener chl) {
            this.support.addChangeListener(chl);
        }

        public void removeChangeListener(ChangeListener chl) {
            this.support.removeChangeListener(chl);
        }
    }

    public static abstract class Support
    implements Index {
        private HashSet listeners;

        public void move(int x, int y) {
            int[] perm = new int[this.getNodesCount()];
            if (x == y) {
                return;
            }
            for (int i = 0; i < perm.length; ++i) {
                perm[i] = i < x && i < y || i > x && i > y ? i : (i > x && i < y ? i - 1 : i + 1);
            }
            perm[x] = y;
            perm[y] = x < y ? y - 1 : y + 1;
            this.reorder(perm);
        }

        public void exchange(int x, int y) {
            int[] perm = new int[this.getNodesCount()];
            for (int i = 0; i < perm.length; ++i) {
                perm[i] = i;
            }
            perm[x] = y;
            perm[y] = x;
            this.reorder(perm);
        }

        public void moveUp(int x) {
            this.exchange(x, x - 1);
        }

        public void moveDown(int x) {
            this.exchange(x, x + 1);
        }

        public void addChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                this.listeners = new HashSet();
            }
            this.listeners.add(chl);
        }

        public void removeChangeListener(ChangeListener chl) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(chl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireChangeEvent(ChangeEvent che) {
            HashSet cloned;
            if (this.listeners == null) {
                return;
            }
            Support support = this;
            synchronized (support) {
                cloned = (HashSet)this.listeners.clone();
            }
            Iterator iter = cloned.iterator();
            while (iter.hasNext()) {
                ((ChangeListener)iter.next()).stateChanged(che);
            }
        }

        public abstract Node[] getNodes();

        public int indexOf(Node node) {
            Node[] arr = this.getNodes();
            for (int i = 0; i < arr.length; ++i) {
                if (!node.equals(arr[i])) continue;
                return i;
            }
            return -1;
        }

        public void reorder() {
            Support.showIndexedCustomizer(this);
        }

        public static void showIndexedCustomizer(Index idx) {
            TMUtil.showIndexedCustomizer(idx);
        }

        public abstract int getNodesCount();

        public abstract void reorder(int[] var1);
    }
}

