/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.FilterNode;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeLookup;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public abstract class Node
extends FeatureDescriptor
implements Lookup.Provider,
HelpCtx.Provider {
    public static final Node EMPTY = new AbstractNode(Children.LEAF);
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_NAME = "name";
    public static final String PROP_SHORT_DESCRIPTION = "shortDescription";
    public static final String PROP_ICON = "icon";
    public static final String PROP_OPENED_ICON = "openedIcon";
    public static final String PROP_PARENT_NODE = "parentNode";
    public static final String PROP_PROPERTY_SETS = "propertySets";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_LEAF = "leaf";
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.nodes.Node");
    private static final boolean doLog = err.isLoggable(1);
    private static final boolean doWarn = err.isLoggable(16);
    private static WeakHashMap lookups = new WeakHashMap(37);
    private Object parent;
    Children hierarchy;
    private transient EventListenerList listeners;
    private static final Set warnedBadProperties = new HashSet(100);
    private static final Lookup.Template TEMPL_COOKIE = new Lookup.Template(Cookie.class);
    private static final Object INIT_LOCK = new Object();

    protected Node(Children h) throws IllegalStateException {
        this(h, null);
    }

    protected Node(Children h, Lookup lookup) throws IllegalStateException {
        this.hierarchy = h;
        lookup = this.replaceProvidedLookup(lookup);
        this.listeners = lookup != null ? new LookupEventList(lookup) : new EventListenerList();
        h.attachTo(this);
    }

    Lookup replaceProvidedLookup(Lookup l) {
        return l;
    }

    final Lookup internalLookup(boolean init) {
        if (this.listeners instanceof LookupEventList) {
            return ((LookupEventList)this.listeners).init(init);
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        Node n = (Node)super.clone();
        Children hier2 = this.hierarchy instanceof Cloneable ? (Children)this.hierarchy.cloneHierarchy() : Children.LEAF;
        n.hierarchy = hier2;
        hier2.attachTo(n);
        n.parent = null;
        n.listeners = this.listeners instanceof LookupEventList ? new LookupEventList(this.internalLookup(false)) : new EventListenerList();
        return n;
    }

    public abstract Node cloneNode();

    private Children getParentChildren() {
        return this.parent instanceof ChildrenArray ? ((ChildrenArray)this.parent).getChildren() : (Children)this.parent;
    }

    final synchronized void assignTo(Children parent, int index) {
        Children ch = this.getParentChildren();
        if (ch != null && ch != parent) {
            throw new IllegalStateException("Cannot initialize " + index + "th child of node " + parent.getNode() + "; it already belongs to node " + ch.getNode());
        }
        if (!(this.parent instanceof ChildrenArray)) {
            this.parent = parent;
        }
    }

    final synchronized void reassignTo(Children currentParent, ChildrenArray itsArray) {
        if (this.parent != currentParent && this.parent != itsArray) {
            throw new IllegalStateException("Unauthorized call to change parent: " + this.parent + " and should be: " + currentParent);
        }
        this.parent = itsArray;
    }

    final synchronized void deassignFrom(Children parent) {
        Children p = this.getParentChildren();
        if (parent != p) {
            throw new IllegalArgumentException("Deassign from wrong parent. Old: " + p + " Caller: " + parent);
        }
        this.parent = null;
    }

    public void setName(String s) {
        String name = super.getName();
        if (name == null || !name.equals(s)) {
            super.setName(s);
            this.fireNameChange(name, s);
        }
    }

    public void setDisplayName(String s) {
        String displayName = super.getDisplayName();
        if (displayName == null || !displayName.equals(s)) {
            super.setDisplayName(s);
            this.fireDisplayNameChange(displayName, s);
        }
    }

    public void setShortDescription(String s) {
        String descr = super.getShortDescription();
        if (descr == null || !descr.equals(s)) {
            super.setShortDescription(s);
            this.fireShortDescriptionChange(descr, s);
        }
    }

    public abstract Image getIcon(int var1);

    public abstract Image getOpenedIcon(int var1);

    public abstract HelpCtx getHelpCtx();

    public final Children getChildren() {
        this.updateChildren();
        return this.hierarchy;
    }

    void updateChildren() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setChildren(Children ch) {
        try {
            Children.PR.enterWriteAccess();
            Node[] oldNodes = null;
            if (this.hierarchy.isInitialized()) {
                oldNodes = this.hierarchy.getNodes();
                this.hierarchy.detachFrom();
            }
            boolean wasLeaf = this.hierarchy == Children.LEAF;
            this.hierarchy = ch;
            this.hierarchy.attachTo(this);
            if (wasLeaf != (this.hierarchy == Children.LEAF)) {
                this.fireOwnPropertyChange(PROP_LEAF, wasLeaf ? Boolean.TRUE : Boolean.FALSE, this.hierarchy == Children.LEAF ? Boolean.TRUE : Boolean.FALSE);
            }
            if (oldNodes != null && !wasLeaf) {
                this.fireSubNodesChange(false, oldNodes, oldNodes);
                this.fireSubNodesChange(true, this.hierarchy.getNodes(), null);
            }
        }
        finally {
            Children.PR.exitWriteAccess();
        }
    }

    public final boolean isLeaf() {
        this.updateChildren();
        return this.hierarchy == Children.LEAF;
    }

    public final Node getParentNode() {
        Children ch = this.getParentChildren();
        return ch == null ? null : ch.getNode();
    }

    public abstract boolean canRename();

    public abstract boolean canDestroy();

    public void destroy() throws IOException {
        Children.MUTEX.postWriteRequest(new Runnable(){

            public void run() {
                Children p = Node.this.getParentChildren();
                if (p != null) {
                    p.remove(new Node[]{Node.this});
                }
                Node.this.fireNodeDestroyed();
            }
        });
    }

    public abstract PropertySet[] getPropertySets();

    public abstract Transferable clipboardCopy() throws IOException;

    public abstract Transferable clipboardCut() throws IOException;

    public abstract Transferable drag() throws IOException;

    public abstract boolean canCopy();

    public abstract boolean canCut();

    public abstract PasteType[] getPasteTypes(Transferable var1);

    public abstract PasteType getDropType(Transferable var1, int var2, int var3);

    public abstract NewType[] getNewTypes();

    public Action[] getActions(boolean context) {
        return context ? this.getContextActions() : this.getActions();
    }

    public SystemAction[] getActions() {
        return NodeOp.getDefaultActions();
    }

    public SystemAction[] getContextActions() {
        return this.getActions();
    }

    public SystemAction getDefaultAction() {
        return null;
    }

    public Action getPreferredAction() {
        return this.getDefaultAction();
    }

    public final JPopupMenu getContextMenu() {
        return NodeOp.findContextMenuImpl(new Node[]{this}, null);
    }

    public abstract boolean hasCustomizer();

    public abstract Component getCustomizer();

    public Cookie getCookie(Class type) {
        Object o;
        Lookup l = this.internalLookup(true);
        if (l != null && (o = l.lookup(type)) instanceof Cookie) {
            return (Cookie)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup getLookup() {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            Lookup l = this.internalLookup(true);
            if (l != null) {
                return l;
            }
            l = this.findDelegatingLookup();
            if (l != null) {
                return l;
            }
            NodeLookup nl = new NodeLookup(this);
            this.registerDelegatingLookup(nl);
            return nl;
        }
    }

    public String getHtmlDisplayName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerDelegatingLookup(NodeLookup l) {
        WeakHashMap weakHashMap = lookups;
        synchronized (weakHashMap) {
            lookups.put(this.listeners, new WeakReference<NodeLookup>(l));
        }
    }

    final Lookup findDelegatingLookup() {
        WeakReference ref = (WeakReference)lookups.get(this.listeners);
        return ref == null ? null : (Lookup)ref.get();
    }

    public abstract Handle getHandle();

    public final void addNodeListener(NodeListener l) {
        this.listeners.add(NodeListener.class, l);
        this.listenerAdded();
    }

    void listenerAdded() {
    }

    public final void removeNodeListener(NodeListener l) {
        this.listeners.remove(NodeListener.class, l);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        int count = -1;
        if (doLog) {
            count = this.getPropertyChangeListenersCount();
        }
        this.listeners.add(PropertyChangeListener.class, l);
        if (doLog) {
            err.log(1, "ADD - " + this.getName() + " [" + count + "]->[" + this.getPropertyChangeListenersCount() + "] " + l);
        }
        this.notifyPropertyChangeListenerAdded(l);
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener l) {
    }

    int getPropertyChangeListenersCount() {
        return this.listeners.getListenerCount(PropertyChangeListener.class);
    }

    protected final boolean hasPropertyChangeListener() {
        return this.getPropertyChangeListenersCount() > 0;
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        int count = -1;
        if (doLog) {
            count = this.getPropertyChangeListenersCount();
        }
        this.listeners.remove(PropertyChangeListener.class, l);
        if (doLog) {
            err.log(1, "RMV - " + this.getName() + " [" + count + "]->[" + this.getPropertyChangeListenersCount() + "] " + l);
        }
        this.notifyPropertyChangeListenerRemoved(l);
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void firePropertyChange(String name, Object o, Object n) {
        int i2;
        if (doWarn && name != null && this.propertySetsAreKnown()) {
            PropertySet[] pss = this.getPropertySets();
            boolean exists = false;
            block3: for (i2 = 0; i2 < pss.length; ++i2) {
                Property[] ps = pss[i2].getProperties();
                for (int j = 0; j < ps.length; ++j) {
                    if (!ps[j].getName().equals(name)) continue;
                    exists = true;
                    continue block3;
                }
            }
            if (!exists) {
                Set i2 = warnedBadProperties;
                synchronized (i2) {
                    String clazz = this.getClass().getName();
                    if (warnedBadProperties.add(clazz + "." + name)) {
                        ErrorManager.getDefault().notify(1, new IllegalStateException("Warning - the node \"" + this.getDisplayName() + "\" [" + clazz + "] is trying to fire the property " + name + " which is not included in its property sets. This is illegal. See IZ #31413 for details."));
                    }
                }
            }
        }
        if (o != null && n != null && (o == n || o.equals(n))) {
            return;
        }
        PropertyChangeEvent ev = null;
        Object[] listeners = this.listeners.getListenerList();
        for (i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != (class$java$beans$PropertyChangeListener == null ? Node.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
            if (ev == null) {
                ev = new PropertyChangeEvent(this, name, o, n);
            }
            ((PropertyChangeListener)listeners[i2 + 1]).propertyChange(ev);
        }
    }

    boolean propertySetsAreKnown() {
        return false;
    }

    protected final void fireNameChange(String o, String n) {
        this.fireOwnPropertyChange(PROP_NAME, o, n);
    }

    protected final void fireDisplayNameChange(String o, String n) {
        this.fireOwnPropertyChange(PROP_DISPLAY_NAME, o, n);
    }

    protected final void fireShortDescriptionChange(String o, String n) {
        this.fireOwnPropertyChange(PROP_SHORT_DESCRIPTION, o, n);
    }

    protected final void fireIconChange() {
        this.fireOwnPropertyChange(PROP_ICON, null, null);
    }

    protected final void fireOpenedIconChange() {
        this.fireOwnPropertyChange(PROP_OPENED_ICON, null, null);
    }

    final void fireSubNodesChange(boolean addAction, Node[] delta, Node[] from) {
        NodeMemberEvent ev = null;
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (ev == null) {
                ev = new NodeMemberEvent(this, addAction, delta, from);
            }
            if (addAction) {
                ((NodeListener)listeners[i + 1]).childrenAdded(ev);
                continue;
            }
            ((NodeListener)listeners[i + 1]).childrenRemoved(ev);
        }
    }

    final void fireReorderChange(int[] indices) {
        NodeReorderEvent ev = null;
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (ev == null) {
                ev = new NodeReorderEvent(this, indices);
            }
            ((NodeListener)listeners[i + 1]).childrenReordered(ev);
        }
    }

    protected final void fireNodeDestroyed() {
        NodeEvent ev = null;
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (ev == null) {
                ev = new NodeEvent(this);
            }
            ((NodeListener)listeners[i + 1]).nodeDestroyed(ev);
        }
    }

    final void fireParentNodeChange(Node o, Node n) {
        this.fireOwnPropertyChange(PROP_PARENT_NODE, o, n);
    }

    protected final void firePropertySetsChange(PropertySet[] o, PropertySet[] n) {
        this.fireOwnPropertyChange(PROP_PROPERTY_SETS, o, n);
    }

    protected final void fireCookieChange() {
        Lookup l = this.findDelegatingLookup();
        if (l instanceof NodeLookup) {
            ((NodeLookup)l).updateLookupAsCookiesAreChanged(null);
        }
        this.fireOwnPropertyChange(PROP_COOKIE, null, null);
    }

    final void fireOwnPropertyChange(String name, Object o, Object n) {
        if (o != null && n != null && (o == n || o.equals(n))) {
            return;
        }
        PropertyChangeEvent ev = null;
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) continue;
            if (ev == null) {
                ev = new PropertyChangeEvent(this, name, o, n);
            }
            ((NodeListener)listeners[i + 1]).propertyChange(ev);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterNode) {
            return ((FilterNode)obj).equals(this);
        }
        return this == obj;
    }

    static String getString(String resName) {
        return NbBundle.getBundle(Node.class).getString(resName);
    }

    public String toString() {
        return super.toString() + "[Name=" + this.getName() + ", displayName=" + this.getDisplayName() + "]";
    }

    private final class LookupEventList
    extends EventListenerList
    implements LookupListener {
        public final Lookup lookup;
        private Lookup.Result result;
        static final /* synthetic */ boolean $assertionsDisabled;

        public LookupEventList(Lookup l) {
            this.lookup = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup init(boolean init) {
            boolean doInit = false;
            Object object = INIT_LOCK;
            synchronized (object) {
                if (init && this.result == null) {
                    this.result = this.lookup.lookup(TEMPL_COOKIE);
                    if (!$assertionsDisabled && this.result == null) {
                        throw new AssertionError((Object)("Null lookup result from " + this.lookup + " in " + Node.this));
                    }
                    this.result.addLookupListener(this);
                    doInit = true;
                }
            }
            if (doInit) {
                this.result.allItems();
            }
            return this.lookup;
        }

        public void resultChanged(LookupEvent ev) {
            FilterNode f;
            if (Node.this instanceof FilterNode && (f = (FilterNode)Node.this).getOriginal() == NodeLookup.NO_COOKIE_CHANGE.get()) {
                return;
            }
            Node.this.fireCookieChange();
        }

        static {
            $assertionsDisabled = !(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = Node.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node).desiredAssertionStatus();
        }
    }

    public static interface Handle
    extends Serializable {
        public static final long serialVersionUID = -4518262478987434353L;

        public Node getNode() throws IOException;
    }

    public static interface Cookie {
    }

    public static abstract class IndexedProperty
    extends Property {
        private Class elementType;

        public IndexedProperty(Class valueType, Class elementType) {
            super(valueType);
            this.elementType = elementType;
        }

        public abstract boolean canIndexedRead();

        public Class getElementType() {
            return this.elementType;
        }

        public abstract Object getIndexedValue(int var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public abstract boolean canIndexedWrite();

        public abstract void setIndexedValue(int var1, Object var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public PropertyEditor getIndexedPropertyEditor() {
            return PropertyEditorManager.findEditor(this.elementType);
        }

        public boolean equals(Object property) {
            try {
                if (!super.equals(property)) {
                    return false;
                }
                Class propElementType = ((IndexedProperty)property).getElementType();
                Class elementType = this.getElementType();
                if (propElementType == null && elementType != null || propElementType != null && elementType == null) {
                    return false;
                }
                return propElementType == null && elementType == null || propElementType.equals(elementType);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            Class ementType = this.getElementType();
            return super.hashCode() * (this.elementType == null ? 1 : this.elementType.hashCode());
        }
    }

    public static abstract class Property
    extends FeatureDescriptor {
        private Class type;
        SoftReference edRef = null;

        public Property(Class valueType) {
            this.type = valueType;
            super.setName("");
        }

        public Class getValueType() {
            return this.type;
        }

        public abstract boolean canRead();

        public abstract Object getValue() throws IllegalAccessException, InvocationTargetException;

        public abstract boolean canWrite();

        public abstract void setValue(Object var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public boolean supportsDefaultValue() {
            return false;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        }

        public boolean isDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.type == null) {
                return null;
            }
            PropertyEditor result = null;
            if (this.edRef != null) {
                result = (PropertyEditor)this.edRef.get();
            }
            if (result == null) {
                result = PropertyEditorManager.findEditor(this.type);
                this.edRef = new SoftReference<PropertyEditor>(result);
            }
            return result;
        }

        public boolean equals(Object property) {
            if (!(property instanceof Property)) {
                return false;
            }
            Class propValueType = ((Property)property).getValueType();
            Class valueType = this.getValueType();
            if (propValueType == null && valueType != null || propValueType != null && valueType == null) {
                return false;
            }
            return ((Property)property).getName().equals(this.getName()) && (propValueType == null && valueType == null || propValueType.equals(valueType));
        }

        public int hashCode() {
            Class valueType = this.getValueType();
            return this.getName().hashCode() * (valueType == null ? 1 : valueType.hashCode());
        }

        public String getHtmlDisplayName() {
            return null;
        }
    }

    public static abstract class PropertySet
    extends FeatureDescriptor {
        public PropertySet() {
        }

        public PropertySet(String name, String displayName, String shortDescription) {
            super.setName(name);
            super.setDisplayName(displayName);
            super.setShortDescription(shortDescription);
        }

        public abstract Property[] getProperties();

        public boolean equals(Object propertySet) {
            if (!(propertySet instanceof PropertySet)) {
                return false;
            }
            return ((PropertySet)propertySet).getName().equals(this.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String getHtmlDisplayName() {
            return null;
        }
    }
}

