/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class CloneableEditor
extends CloneableTopComponent
implements CloneableEditorSupport.Pane {
    protected JEditorPane pane;
    private CloneableEditorSupport support;
    private boolean initialized;
    private int cursorPosition = -1;
    private Component customComponent;
    private JToolBar customToolbar;
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;

    public CloneableEditor() {
        this((CloneableEditorSupport)null);
    }

    public CloneableEditor(CloneableEditorSupport support) {
        this.support = support;
        this.updateName();
        this.setCloseOperation(0);
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx fromKit = HelpCtx.findHelp(this.support.kit());
        if (fromKit != null) {
            return fromKit;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose(Workspace workspace, boolean last) {
        boolean result = super.canClose(workspace, last);
        int closeOp = this.getCloseOperation();
        if (result && (closeOp == 0 || closeOp == 1 && last)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (CloneableEditor.this.pane != null) {
                        StyledDocument doc = CloneableEditor.this.support.createStyledDocument(CloneableEditor.this.pane.getEditorKit());
                        CloneableEditor.this.pane.setDocument(doc);
                        CloneableEditor.this.pane.setEditorKit(null);
                    }
                    CloneableEditor.this.removeAll();
                    CloneableEditor.this.initialized = false;
                }
            });
        }
        return result;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.initialize();
    }

    private void initialize() {
        Caret caret;
        Document ce;
        if (this.initialized || this.discard()) {
            return;
        }
        this.initialized = true;
        Task prepareTask = this.support.prepareDocument();
        prepareTask.waitFinished();
        StyledDocument doc = this.support.getDocument();
        this.setLayout(new BorderLayout());
        QuietEditorPane pane = new QuietEditorPane();
        pane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CloneableEditor.class, "ACS_CloneableEditor_QuietEditorPane", this.getName()));
        pane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneableEditor.class, "ACSD_CloneableEditor_QuietEditorPane", this.getAccessibleContext().getAccessibleDescription()));
        this.pane = pane;
        ActionMap am = this.getActionMap();
        ActionMap paneMap = pane.getActionMap();
        am.setParent(paneMap);
        paneMap.put("cut-to-clipboard", this.getAction("cut-to-clipboard"));
        paneMap.put("copy-to-clipboard", this.getAction("copy-to-clipboard"));
        paneMap.put("delete", this.getAction("delete-next"));
        paneMap.put("paste-from-clipboard", this.getAction("paste-from-clipboard"));
        pane.setEditorKit(this.support.kit());
        pane.setDocument(doc);
        if (doc instanceof NbDocument.CustomEditor) {
            ce = (NbDocument.CustomEditor)((Object)doc);
            this.customComponent = ce.createEditor(pane);
            if (this.customComponent == null) {
                throw new IllegalStateException("Document:" + doc + " implementing NbDocument.CustomEditor may not" + " return null component");
            }
            this.add(this.customComponent, "Center");
        } else {
            JScrollPane noBorderPane = new JScrollPane(pane);
            pane.setBorder(null);
            this.add((Component)noBorderPane, "Center");
        }
        if (doc instanceof NbDocument.CustomToolbar) {
            ce = (NbDocument.CustomToolbar)((Object)doc);
            this.customToolbar = ce.createToolbar(pane);
            if (this.customToolbar == null) {
                throw new IllegalStateException("Document:" + doc + " implementing NbDocument.CustomToolbar may not" + " return null toolbar");
            }
            Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
            this.customToolbar.setBorder(b);
            this.add((Component)this.customToolbar, "North");
        }
        pane.setWorking(3);
        if (this.cursorPosition != -1 && (caret = pane.getCaret()) != null) {
            caret.setDot(this.cursorPosition);
        }
        this.support.ensureAnnotationsLoaded();
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    protected void componentOpened() {
        super.componentOpened();
        CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            ces.firePropertyChange("openedPanes", null, null);
        }
    }

    protected void componentClosed() {
        super.componentClosed();
        CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            ces.firePropertyChange("openedPanes", null, null);
        }
    }

    public void open(Workspace workspace) {
        if (this.discard()) {
            ErrorManager.getDefault().log(16, "Can not open " + this + " component," + " its support environment is not valid" + " [support=" + this.support + ", env=" + (this.support == null ? null : this.support.env()) + "]");
        } else {
            Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            this.dockIfNeeded(realWorkspace);
            super.open(workspace);
        }
    }

    protected boolean closeLast() {
        if (!this.support.canClose()) {
            return false;
        }
        this.support.notifyClosed();
        if (this.support.getLastSelected() == this) {
            this.support.setLastSelected(null);
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] sa = super.getSystemActions();
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = this.getClass().getClassLoader();
            }
            Class<?> c = Class.forName("org.openide.actions.FileSystemAction", true, l);
            SystemAction ra = (SystemAction)SystemAction.findObject(c, true);
            sa = SystemAction.linkActions(sa, new SystemAction[]{ra});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sa;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            this.customComponent.requestFocus();
        } else if (this.pane != null) {
            this.pane.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public boolean requestDefaultFocus() {
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Rectangle bounds = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(bounds.width / 2, bounds.height / 2);
    }

    private Action getAction(String key) {
        if (key == null) {
            return null;
        }
        EditorKit kit = this.support.kit();
        if (kit == null) {
            return null;
        }
        Action[] actions = kit.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!key.equals(actions[i].getValue("Name"))) continue;
            return actions[i];
        }
        return null;
    }

    protected void componentActivated() {
        this.support.setLastSelected(this);
    }

    public void updateName() {
        final CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    CloneableEditor.this.setDisplayName(ces.messageName());
                    CloneableEditor.this.setName(ces.messageName());
                    CloneableEditor.this.setToolTipText(ces.messageToolTip());
                }
            });
        }
    }

    protected String preferredID() {
        CloneableEditorSupport ces = this.cloneableEditorSupport();
        if (ces != null) {
            return ces.documentID();
        }
        return "";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.support != null ? this.support.env() : null);
        int pos = 0;
        JEditorPane p = this.pane;
        if (p != null) {
            Caret caret = p.getCaret();
            if (caret != null) {
                pos = caret.getDot();
            } else if (p instanceof QuietEditorPane) {
                int lastPos = ((QuietEditorPane)p).getLastPosition();
                if (lastPos == -1) {
                    ErrorManager.getDefault().notify(1, new IllegalStateException("Pane=" + p + "was not initialized yet!"));
                } else {
                    pos = lastPos;
                }
            } else {
                StyledDocument doc;
                StyledDocument styledDocument = doc = this.support != null ? this.support.getDocument() : null;
                if (doc != null) {
                    ErrorManager.getDefault().notify(1, new IllegalStateException("Caret is null in editor pane=" + p + "\nsupport=" + this.support + "\ndoc=" + doc));
                }
            }
        }
        out.writeObject(new Integer(pos));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Object firstObject = in.readObject();
        if (firstObject instanceof CloneableOpenSupport.Env) {
            CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)firstObject;
            CloneableOpenSupport os = env.findCloneableOpenSupport();
            this.support = (CloneableEditorSupport)os;
        }
        int offset = (Integer)in.readObject();
        if (!this.discard()) {
            this.cursorPosition = offset;
        }
        this.updateName();
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.support.initializeCloneableEditor(this);
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.env().isValid();
    }

    private void dockIfNeeded(Workspace workspace) {
        Mode ourMode = workspace.findMode(this);
        if (ourMode == null) {
            this.editorMode(workspace).dockInto(this);
        }
    }

    private Mode editorMode(Workspace workspace) {
        Mode ourMode = workspace.findMode(this);
        if (ourMode == null) {
            ourMode = workspace.createMode("editor", this.getName(), CloneableEditorSupport.class.getResource("/org/openide/resources/editorMode.gif"));
        }
        return ourMode;
    }

    public CloneableTopComponent getComponent() {
        return this;
    }

    public JEditorPane getEditorPane() {
        this.initialize();
        return this.pane;
    }

    public void ensureVisible() {
        this.open();
        this.requestVisible();
    }
}

