/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.LazyLines;
import org.openide.text.Line;
import org.openide.text.LineListener;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public abstract class DocumentLine
extends Line {
    protected PositionRef pos;
    private boolean breakpoint;
    private transient boolean error;
    private transient boolean current;
    private transient LR listener;
    private transient DocumentListener docL;
    private static WeakHashMap assigned = new WeakHashMap(5);
    private List lineParts = new ArrayList(3);
    static final long serialVersionUID = 3213776466939427487L;

    public DocumentLine(Lookup obj, PositionRef pos) {
        super(obj);
        this.pos = pos;
    }

    void init() {
        this.listener = new LR();
        this.pos.getCloneableEditorSupport().addChangeListener(WeakListeners.change(this.listener, this.pos.getCloneableEditorSupport()));
    }

    public int getLineNumber() {
        try {
            return this.pos.getLine();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    public abstract void show(int var1, int var2);

    public void setBreakpoint(boolean b) {
        if (this.breakpoint != b) {
            this.breakpoint = b;
            this.refreshState();
        }
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    public void markError() {
        DocumentLine previous = this.registerLine(1, this);
        if (previous != null) {
            previous.error = false;
            previous.refreshState();
        }
        this.error = true;
        this.refreshState();
    }

    public void unmarkError() {
        this.error = false;
        this.registerLine(1, null);
        this.refreshState();
    }

    public void markCurrentLine() {
        DocumentLine previous = this.registerLine(0, this);
        if (previous != null) {
            previous.current = false;
            previous.refreshState();
        }
        this.current = true;
        this.refreshState();
    }

    public void unmarkCurrentLine() {
        this.current = false;
        this.registerLine(0, null);
        this.refreshState();
    }

    synchronized void refreshState() {
        StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc != null) {
            if (this.docL != null) {
                doc.removeDocumentListener(this.docL);
            }
            if (this.error) {
                NbDocument.markError(doc, this.pos.getOffset());
                this.docL = WeakListeners.document(this.listener, doc);
                doc.addDocumentListener(this.docL);
                return;
            }
            if (this.current) {
                NbDocument.markCurrent(doc, this.pos.getOffset());
                return;
            }
            if (this.breakpoint) {
                NbDocument.markBreakpoint(doc, this.pos.getOffset());
                return;
            }
            NbDocument.markNormal(doc, this.pos.getOffset());
            return;
        }
    }

    public int hashCode() {
        return this.pos.getCloneableEditorSupport().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DocumentLine) {
            DocumentLine dl = (DocumentLine)o;
            if (dl.pos.getCloneableEditorSupport() == this.pos.getCloneableEditorSupport()) {
                return dl.getLineNumber() == this.getLineNumber();
            }
        }
        return false;
    }

    private DocumentLine registerLine(int indx, DocumentLine line) {
        DocumentLine prev;
        CloneableEditorSupport es = this.pos.getCloneableEditorSupport();
        DocumentLine[] arr = (DocumentLine[])assigned.get(es);
        if (arr != null) {
            prev = arr[indx];
        } else {
            arr = new DocumentLine[2];
            assigned.put(es, arr);
            prev = null;
        }
        arr[indx] = line;
        return prev;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.pos);
        oos.writeBoolean(this.breakpoint);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.pos = (PositionRef)ois.readObject();
        this.setBreakpoint(ois.readBoolean());
        this.lineParts = new ArrayList(3);
    }

    Object readResolve() throws ObjectStreamException {
        return this.pos.getCloneableEditorSupport().getLineSet().registerLine(this);
    }

    protected void addAnnotation(Annotation anno) {
        super.addAnnotation(anno);
        StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        try {
            if (!anno.isInDocument()) {
                anno.setInDocument(true);
                FindAnnotationPosition fap = new FindAnnotationPosition(doc, this.pos.getPosition());
                doc.render(fap);
                NbDocument.addAnnotation(doc, fap.getAnnotationPosition(), -1, anno);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, ex);
        }
    }

    protected void removeAnnotation(Annotation anno) {
        super.removeAnnotation(anno);
        StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        if (anno.isInDocument()) {
            anno.setInDocument(false);
            NbDocument.removeAnnotation(doc, anno);
        }
    }

    void attachDetachAnnotations(StyledDocument doc, boolean closing) {
        int i;
        Position annoPos = null;
        if (!closing) {
            try {
                annoPos = this.pos.getPosition();
                FindAnnotationPosition fap = new FindAnnotationPosition(doc, annoPos);
                doc.render(fap);
                annoPos = fap.getAnnotationPosition();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, ex);
            }
        }
        List list = this.getAnnotations();
        for (i = 0; i < list.size(); ++i) {
            Annotation anno = (Annotation)list.get(i);
            if (!closing) {
                if (anno.isInDocument()) continue;
                anno.setInDocument(true);
                NbDocument.addAnnotation(doc, annoPos, -1, anno);
                continue;
            }
            if (!anno.isInDocument()) continue;
            anno.setInDocument(false);
            NbDocument.removeAnnotation(doc, anno);
        }
        for (i = 0; i < this.lineParts.size(); ++i) {
            ((Part)this.lineParts.get(i)).attachDetachAnnotations(doc, closing);
        }
    }

    public String getText() {
        final StyledDocument doc = this.pos.getCloneableEditorSupport().getDocument();
        if (doc == null) {
            return null;
        }
        final String[] retStringArray = new String[1];
        doc.render(new Runnable(){

            public void run() {
                int lineNumber = DocumentLine.this.getLineNumber();
                int lineStart = NbDocument.findLineOffset(doc, lineNumber);
                int lineEnd = lineNumber + 1 >= NbDocument.findLineRootElement(doc).getElementCount() ? doc.getLength() : NbDocument.findLineOffset(doc, lineNumber + 1);
                try {
                    retStringArray[0] = doc.getText(lineStart, lineEnd - lineStart);
                }
                catch (BadLocationException ex) {
                    ErrorManager.getDefault().notify(4096, ex);
                    retStringArray[0] = null;
                }
            }
        });
        return retStringArray[0];
    }

    void addLinePart(Part linePart) {
        this.lineParts.add(linePart);
    }

    void moveLinePart(Part linePart, DocumentLine newLine) {
        this.lineParts.remove(linePart);
        newLine.addLinePart(linePart);
        linePart.changeLine(newLine);
    }

    void notifyChange(DocumentEvent p0, Set set, StyledDocument doc) {
        Position p;
        int i = 0;
        while (i < this.lineParts.size()) {
            Part part = (Part)this.lineParts.get(i);
            part.handleDocumentChange(p0);
            if (NbDocument.findLineNumber(doc, part.getOffset()) != part.getLine().getLineNumber()) {
                DocumentLine line = (DocumentLine)set.getCurrent(NbDocument.findLineNumber(doc, part.getOffset()));
                this.moveLinePart(part, line);
                continue;
            }
            ++i;
        }
        try {
            p = this.pos.getPosition();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, ex);
            p = null;
        }
        if (p != null) {
            int lineStartOffset = NbDocument.findLineOffset(doc, NbDocument.findLineNumber(doc, p.getOffset()));
            CloneableEditorSupport support = this.pos.getCloneableEditorSupport();
            this.pos = new PositionRef(support.getPositionManager(), lineStartOffset, Position.Bias.Forward);
            List annos = this.getAnnotations();
            int annosSize = annos.size();
            if (annosSize > 0) {
                try {
                    p = this.pos.getPosition();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException();
                }
                for (int i2 = 0; i2 < annosSize; ++i2) {
                    Annotation anno = (Annotation)annos.get(i2);
                    if (anno.isInDocument()) {
                        anno.setInDocument(false);
                        NbDocument.removeAnnotation(support.getDocument(), anno);
                    }
                    if (anno.isInDocument()) continue;
                    anno.setInDocument(true);
                    NbDocument.addAnnotation(support.getDocument(), p, -1, anno);
                }
            }
        }
    }

    void notifyMove() {
        this.updatePositionRef();
        for (int i = 0; i < this.lineParts.size(); ++i) {
            ((Part)this.lineParts.get(i)).firePropertyChange("line", null, null);
        }
    }

    private void updatePositionRef() {
    }

    public static abstract class Set
    extends Line.Set {
        final LineListener listener;
        private List list;

        public Set(StyledDocument doc) {
            this(doc, null);
        }

        Set(StyledDocument doc, CloneableEditorSupport support) {
            this.listener = new LineListener(doc, support);
        }

        void linesChanged(int startLineNumber, int endLineNumber, DocumentEvent p0) {
            List changedLines = this.getLinesFromRange(startLineNumber, endLineNumber);
            Iterator it = changedLines.iterator();
            while (it.hasNext()) {
                Line line = (Line)it.next();
                line.firePropertyChange("text", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyChange(p0, this, this.listener.doc);
            }
        }

        void linesMoved(int startLineNumber, int endLineNumber) {
            List movedLines = this.getLinesFromRange(startLineNumber, endLineNumber);
            Iterator it = movedLines.iterator();
            while (it.hasNext()) {
                Line line = (Line)it.next();
                line.firePropertyChange("lineNumber", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyMove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getLinesFromRange(int startLineNumber, int endLineNumber) {
            ArrayList<Line> linesInRange = new ArrayList<Line>(10);
            WeakHashMap weakHashMap = this.findWeakHashMap();
            synchronized (weakHashMap) {
                Iterator it = this.findWeakHashMap().keySet().iterator();
                while (it.hasNext()) {
                    Line line = (Line)it.next();
                    int lineNumber = line.getLineNumber();
                    if (startLineNumber > lineNumber || lineNumber > endLineNumber) continue;
                    linesInRange.add(line);
                }
            }
            return linesInRange;
        }

        public synchronized List getLines() {
            if (this.list == null) {
                this.list = new LazyLines(this);
            }
            return this.list;
        }

        public Line getOriginal(int line) throws IndexOutOfBoundsException {
            int newLine = this.listener.getLine(line);
            int offset = NbDocument.findLineOffset(this.listener.doc, newLine);
            return this.safelyRegisterLine(this.createLine(offset));
        }

        public int getOriginalLineNumber(Line line) {
            Line find = this.findLine(line);
            if (find != null) {
                return this.listener.getOld(find.getLineNumber());
            }
            return -1;
        }

        public Line getCurrent(int line) throws IndexOutOfBoundsException {
            int offset = NbDocument.findLineOffset(this.listener.doc, line);
            return this.safelyRegisterLine(this.createLine(offset));
        }

        protected abstract Line createLine(int var1);

        private Line safelyRegisterLine(Line line) {
            class DocumentRenderer
            implements Runnable {
                public Line result;
                private final /* synthetic */ Line val$line;
                private final /* synthetic */ Set this$0;

                DocumentRenderer(Set this$0, Line val$line) {
                    this.this$0 = this$0;
                    this.val$line = val$line;
                }

                public void run() {
                    this.result = Set.access$101(this.this$0, this.val$line);
                }
            }
            DocumentRenderer renderer = new DocumentRenderer(this, line);
            this.listener.doc.render(renderer);
            return renderer.result;
        }

        static /* synthetic */ Line access$101(Set x0, Line x1) {
            return super.registerLine(x1);
        }
    }

    private final class LR
    implements Runnable,
    ChangeListener,
    DocumentListener {
        private static final int REFRESH = 0;
        private static final int UNMARK = 1;
        private static final int ATTACH_DETACH = 2;
        private int actionId;
        private EnhancedChangeEvent ev;

        public LR() {
        }

        public LR(int actionId) {
            this.actionId = actionId;
        }

        public LR(EnhancedChangeEvent ev) {
            this.actionId = 2;
            this.ev = ev;
        }

        public void run() {
            switch (this.actionId) {
                case 0: {
                    DocumentLine.this.refreshState();
                    break;
                }
                case 1: {
                    DocumentLine.this.unmarkError();
                    break;
                }
                case 2: {
                    DocumentLine.this.attachDetachAnnotations(this.ev.getDocument(), this.ev.isClosingDocument());
                    this.ev = null;
                }
            }
        }

        private void invoke(int op) {
            new LR(op).run();
        }

        private void invoke(EnhancedChangeEvent ev) {
            new LR(ev).run();
        }

        public void stateChanged(ChangeEvent ev) {
            this.invoke(0);
            this.invoke((EnhancedChangeEvent)ev);
        }

        public void removeUpdate(DocumentEvent p0) {
            this.invoke(1);
        }

        public void insertUpdate(DocumentEvent p0) {
            this.invoke(1);
        }

        public void changedUpdate(DocumentEvent p0) {
        }
    }

    static class Part
    extends Line.Part {
        private PositionRef position;
        private Line line;
        private int length;
        private int previousOffset;

        public Part(Line line, PositionRef position, int length) {
            this.position = position;
            this.line = line;
            this.length = length;
            this.previousOffset = position.getOffset();
        }

        public int getColumn() {
            try {
                return this.position.getColumn();
            }
            catch (IOException ex) {
                return 0;
            }
        }

        public int getLength() {
            return this.length;
        }

        public Line getLine() {
            return this.line;
        }

        int getOffset() {
            return this.position.getOffset();
        }

        void changeLine(Line line) {
            this.line = line;
            this.firePropertyChange("lineNumber", null, line);
        }

        protected void addAnnotation(Annotation anno) {
            super.addAnnotation(anno);
            StyledDocument doc = this.position.getCloneableEditorSupport().getDocument();
            if (doc == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            try {
                if (!anno.isInDocument()) {
                    anno.setInDocument(true);
                    NbDocument.addAnnotation(doc, this.position.getPosition(), this.length, anno);
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, ex);
            }
        }

        protected void removeAnnotation(Annotation anno) {
            super.removeAnnotation(anno);
            StyledDocument doc = this.position.getCloneableEditorSupport().getDocument();
            if (doc == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            if (anno.isInDocument()) {
                anno.setInDocument(false);
                NbDocument.removeAnnotation(doc, anno);
            }
        }

        public String getText() {
            StyledDocument doc = this.position.getCloneableEditorSupport().getDocument();
            if (doc == null) {
                return null;
            }
            String[] retStringArray = new String[1];
            doc.render(new Runnable(this, retStringArray, doc){
                private final /* synthetic */ String[] val$retStringArray;
                private final /* synthetic */ StyledDocument val$doc;
                private final /* synthetic */ Part this$0;
                {
                    this.this$0 = this$0;
                    this.val$retStringArray = val$retStringArray;
                    this.val$doc = val$doc;
                }

                public void run() {
                    try {
                        this.val$retStringArray[0] = this.val$doc.getText(Part.access$000(this.this$0).getOffset(), this.this$0.getLength());
                    }
                    catch (BadLocationException ex) {
                        ErrorManager.getDefault().notify(4096, ex);
                        this.val$retStringArray[0] = null;
                    }
                }
            });
            return retStringArray[0];
        }

        void attachDetachAnnotations(StyledDocument doc, boolean closing) {
            List list = this.getAnnotations();
            for (int i = 0; i < list.size(); ++i) {
                Annotation anno = (Annotation)list.get(i);
                if (!closing) {
                    try {
                        if (anno.isInDocument()) continue;
                        anno.setInDocument(true);
                        NbDocument.addAnnotation(doc, this.position.getPosition(), this.getLength(), anno);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(4096, ex);
                    }
                    continue;
                }
                if (!anno.isInDocument()) continue;
                anno.setInDocument(false);
                NbDocument.removeAnnotation(doc, anno);
            }
        }

        void handleDocumentChange(DocumentEvent p0) {
            if (p0.getType().equals(DocumentEvent.EventType.INSERT) && p0.getOffset() >= this.previousOffset && p0.getOffset() < this.previousOffset + this.getLength()) {
                this.firePropertyChange("text", null, null);
            }
            if (p0.getType().equals(DocumentEvent.EventType.REMOVE) && (p0.getOffset() >= this.previousOffset && p0.getOffset() < this.previousOffset + this.getLength() || p0.getOffset() < this.previousOffset && p0.getOffset() + p0.getLength() > this.previousOffset)) {
                this.firePropertyChange("text", null, null);
            }
            if ((p0.getType().equals(DocumentEvent.EventType.INSERT) || p0.getType().equals(DocumentEvent.EventType.REMOVE)) && p0.getOffset() < this.previousOffset) {
                this.firePropertyChange("column", null, null);
            }
            this.previousOffset = this.position.getOffset();
        }

        static /* synthetic */ PositionRef access$000(Part x0) {
            return x0.position;
        }
    }

    private static final class FindAnnotationPosition
    implements Runnable {
        private StyledDocument doc;
        private Position annoPos;

        FindAnnotationPosition(StyledDocument doc, Position pos) {
            this.doc = doc;
            this.annoPos = pos;
        }

        public void run() {
            int lineStartOffset;
            int offset = this.annoPos.getOffset();
            if (offset != (lineStartOffset = this.doc.getParagraphElement(offset).getStartOffset())) {
                try {
                    this.annoPos = this.doc.createPosition(lineStartOffset);
                }
                catch (BadLocationException e) {
                    throw new IllegalArgumentException();
                }
            }
        }

        Position getAnnotationPosition() {
            return this.annoPos;
        }
    }
}

