/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import javax.swing.event.EventListenerList;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public abstract class ExClipboard
extends Clipboard {
    private EventListenerList listeners = new EventListenerList();

    public ExClipboard(String name) {
        super(name);
    }

    public final void addClipboardListener(ClipboardListener list) {
        this.listeners.add(ClipboardListener.class, list);
    }

    public final void removeClipboardListener(ClipboardListener list) {
        this.listeners.remove(ClipboardListener.class, list);
    }

    protected final void fireClipboardChange() {
        Object[] l = this.listeners.getListenerList();
        ClipboardEvent ev = null;
        for (int i = l.length - 2; i >= 0; i -= 2) {
            ClipboardListener list = (ClipboardListener)l[i + 1];
            if (ev == null) {
                ev = new ClipboardEvent(this);
            }
            list.clipboardChanged(ev);
        }
    }

    protected abstract Convertor[] getConvertors();

    public Transferable convert(Transferable t) {
        Convertor[] convertors = this.getConvertors();
        for (int i = 0; i < convertors.length; ++i) {
            t = convertors[i].convert(t);
        }
        return t;
    }

    public static void transferableAccepted(Transferable t, int action) {
        if (t instanceof ExTransferable) {
            ((ExTransferable)t).fireAccepted(action);
        } else if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                for (int i = 0; i < cnt; ++i) {
                    ExClipboard.transferableAccepted(mto.getTransferableAt(i), action);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transferableRejected(Transferable t) {
        if (t instanceof ExTransferable) {
            ((ExTransferable)t).fireRejected();
        } else if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                for (int i = 0; i < cnt; ++i) {
                    ExClipboard.transferableRejected(mto.getTransferableAt(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        if (this.contents != null) {
            ExClipboard.transferableOwnershipLost(this.contents);
        }
        super.setContents(contents, owner);
    }

    public static void transferableOwnershipLost(Transferable t) {
        if (t instanceof ExTransferable) {
            ((ExTransferable)t).fireOwnershipLost();
        } else if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                for (int i = 0; i < cnt; ++i) {
                    ExClipboard.transferableOwnershipLost(mto.getTransferableAt(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface Convertor {
        public Transferable convert(Transferable var1);
    }
}

