/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public abstract class CloneableTopComponent
extends TopComponent
implements Externalizable,
TopComponent.Cloneable {
    static final long serialVersionUID = 4893753008783256289L;
    private Ref ref;
    public static final Ref EMPTY = new Ref();

    public final Object clone() {
        return this.cloneComponent();
    }

    public final CloneableTopComponent cloneTopComponent() {
        CloneableTopComponent top = this.createClonedObject();
        top.setReference(this.getReference());
        return top;
    }

    public final TopComponent cloneComponent() {
        return this.cloneTopComponent();
    }

    protected CloneableTopComponent createClonedObject() {
        try {
            NbMarshalledObject o = new NbMarshalledObject(this);
            CloneableTopComponent top = (CloneableTopComponent)o.get();
            return top;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    public final synchronized Ref getReference() {
        if (this.ref == null) {
            this.ref = new Ref(this);
        }
        return this.ref;
    }

    public final synchronized void setReference(Ref another) {
        if (another == EMPTY) {
            throw new IllegalArgumentException(NbBundle.getBundle(CloneableTopComponent.class).getString("EXC_CannotAssign"));
        }
        if (this.ref != null) {
            this.ref.removeComponent(this);
        }
        another.register(this);
        this.ref = another;
    }

    protected void componentClosed() {
        super.componentClosed();
        if (!this.isOpened()) {
            this.getReference().unregister(this);
        }
    }

    public boolean canClose(Workspace workspace, boolean last) {
        if (last) {
            return this.getReference().unregister(this);
        }
        return true;
    }

    protected boolean closeLast() {
        return true;
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        Ref ref;
        super.readExternal(oi);
        if (this.serialVersion != 0 && (ref = (Ref)oi.readObject()) != null) {
            this.setReference(ref);
        }
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.ref);
    }

    public static class Ref
    implements Serializable {
        static final long serialVersionUID = 5543148876020730556L;
        private static final Object LOCK = new Object();
        private transient Set componentSet = new HashSet(7);

        protected Ref() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ref(CloneableTopComponent c) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.add(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration getComponents() {
            HashSet components;
            Object object = LOCK;
            synchronized (object) {
                components = new HashSet(this.componentSet);
            }
            return Collections.enumeration(components);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = LOCK;
            synchronized (object) {
                return this.componentSet.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloneableTopComponent getAnyComponent() {
            Object object = LOCK;
            synchronized (object) {
                return (CloneableTopComponent)this.componentSet.iterator().next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloneableTopComponent getArbitraryComponent() {
            TopComponent activated = WindowManager.getDefault().getRegistry().getActivated();
            Object object = LOCK;
            synchronized (object) {
                if (this.componentSet.contains(activated)) {
                    return (CloneableTopComponent)activated;
                }
                Iterator it = this.componentSet.iterator();
                if (it.hasNext()) {
                    return (CloneableTopComponent)it.next();
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void register(CloneableTopComponent c) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.add(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean unregister(CloneableTopComponent c) {
            int componentCount;
            Object object = LOCK;
            synchronized (object) {
                if (!this.componentSet.contains(c)) {
                    return true;
                }
                componentCount = this.componentSet.size();
            }
            if (componentCount > 1 || c.closeLast()) {
                this.removeComponent(c);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeComponent(CloneableTopComponent c) {
            Object object = LOCK;
            synchronized (object) {
                this.componentSet.remove(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Object object = LOCK;
            synchronized (object) {
                this.componentSet = new HashSet(7);
            }
        }
    }
}

