/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import org.openide.windows.TopComponent;

final class DelegateActionMap
extends ActionMap {
    private JComponent component;
    private ActionMap delegate;

    public DelegateActionMap(JComponent c) {
        this.component = c;
    }

    public DelegateActionMap(TopComponent c, ActionMap delegate) {
        this.component = c;
        this.delegate = delegate;
    }

    public int size() {
        return this.keys().length;
    }

    public Action get(Object key) {
        Component owner;
        Action a;
        ActionMap m;
        ActionMap actionMap = m = this.delegate == null ? this.component.getActionMap() : this.delegate;
        if (m != null && (a = m.get(key)) != null) {
            return a;
        }
        Action found = null;
        for (owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); owner != null && owner != this.component; owner = owner.getParent()) {
            if (found != null || !(owner instanceof JComponent) || (m = ((JComponent)owner).getActionMap()) == null) continue;
            found = m.get(key);
        }
        return owner == this.component ? found : null;
    }

    public Object[] allKeys() {
        return this.keys(true);
    }

    public Object[] keys() {
        return this.keys(false);
    }

    private Object[] keys(boolean all) {
        ActionMap m;
        HashSet<Object> keys = new HashSet<Object>();
        ActionMap actionMap = m = this.delegate == null ? this.component.getActionMap() : this.delegate;
        if (m != null) {
            List<Object> l = all ? Arrays.asList(m.allKeys()) : Arrays.asList(m.keys());
            keys.addAll(l);
        }
        return keys.toArray();
    }

    public void remove(Object key) {
        if (this.delegate != null) {
            this.delegate.remove(key);
        }
    }

    public void setParent(ActionMap map) {
        if (this.delegate != null) {
            this.delegate.setParent(map);
        }
    }

    public void clear() {
        if (this.delegate != null) {
            this.delegate.clear();
        }
    }

    public void put(Object key, Action action) {
        if (this.delegate != null) {
            this.delegate.put(key, action);
        }
    }

    public ActionMap getParent() {
        return this.delegate == null ? null : this.delegate.getParent();
    }
}

