/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class XMLUtilImpl {
    private XMLUtilImpl() {
    }

    static void write(Document doc, OutputStream out, String encoding) throws IOException {
        block15: {
            Class<?> dock = doc.getClass();
            try {
                if (("com.sun.xml.tree.XmlDocument".equals(dock.getName()) || "org.apache.crimson.tree.XmlDocument".equals(dock.getName())) && !XMLUtilImpl.hasNamespaces(doc)) {
                    Method write = dock.getDeclaredMethod("write", OutputStream.class);
                    write.invoke((Object)doc, out);
                    break block15;
                }
                ClassLoader cl = dock.getClassLoader();
                Class<?> serka = null;
                try {
                    serka = Class.forName("org.apache.xml.serialize.XMLSerializer", true, cl);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (serka == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                    try {
                        serka = Class.forName("org.apache.xml.serialize.XMLSerializer", true, cl);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                if (serka == null) {
                    cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (cl == null) {
                        cl = XMLUtilImpl.class.getClassLoader();
                    }
                    serka = Class.forName("org.apache.xml.serialize.XMLSerializer", true, cl);
                }
                Class<?> forka = Class.forName("org.apache.xml.serialize.OutputFormat", true, cl);
                Object serin = serka.newInstance();
                Object forin = forka.newInstance();
                Method setmet = null;
                setmet = forka.getMethod("setMethod", String.class);
                setmet.invoke(forin, "xml");
                setmet = forka.getMethod("setIndenting", Boolean.TYPE);
                setmet.invoke(forin, Boolean.TRUE);
                setmet = forka.getMethod("setLineWidth", Integer.TYPE);
                setmet.invoke(forin, new Integer(0));
                setmet = forka.getMethod("setLineSeparator", String.class);
                setmet.invoke(forin, (Object[])new String[]{System.getProperty("line.separator")});
                Method init = serka.getMethod("setOutputByteStream", OutputStream.class);
                init.invoke(serin, out);
                Method setenc = forka.getMethod("setEncoding", String.class);
                setenc.invoke(forin, encoding);
                Method setout = serka.getMethod("setOutputFormat", forka);
                setout.invoke(serin, forin);
                Method setnam = serka.getMethod("setNamespaces", Boolean.TYPE);
                setnam.invoke(serin, Boolean.TRUE);
                Method asDOM = serka.getMethod("asDOMSerializer", new Class[0]);
                Object impl = asDOM.invoke(serin, new Object[0]);
                Method serialize = impl.getClass().getMethod("serialize", Document.class);
                serialize.invoke(impl, doc);
            }
            catch (IllegalAccessException ex) {
                XMLUtilImpl.handleImplementationException(ex);
            }
            catch (InstantiationException ex) {
                XMLUtilImpl.handleImplementationException(ex);
            }
            catch (IllegalArgumentException ex) {
                XMLUtilImpl.handleImplementationException(ex);
            }
            catch (NoSuchMethodException ex) {
                XMLUtilImpl.handleImplementationException(ex);
            }
            catch (ClassNotFoundException ex) {
                XMLUtilImpl.handleImplementationException(ex);
            }
            catch (InvocationTargetException ex) {
                XMLUtilImpl.handleTargetException(ex);
            }
        }
    }

    private static boolean hasNamespaces(Document doc) {
        NodeList l = doc.getElementsByTagName("*");
        for (int i = 0; i < l.getLength(); ++i) {
            if (((Element)l.item(i)).getNamespaceURI() == null) continue;
            return true;
        }
        return false;
    }

    private static void handleTargetException(InvocationTargetException ex) throws IOException {
        Throwable t = ex.getTargetException();
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    private static void handleImplementationException(Exception ex) throws IOException {
        throw (IOException)new IOException("Unsupported DOM document implementation! " + ex).initCause(ex);
    }
}

