/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.dynamic;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.dynamic.Dynamic;
import net.sf.staccatocommons.dynamic.internal.Classes;
import net.sf.staccatocommons.dynamic.internal.NullDynamic;
import net.sf.staccatocommons.dynamic.internal.ReflectiveDynamic;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Dynamics {
    private static final NullDynamic NULL = new NullDynamic();

    @NonNull
    public static Dynamic from(@NonNull Object object) {
        Ensure.isNotNull((String)"var0", (Object)object);
        return new ReflectiveDynamic(object);
    }

    @NonNull
    public static Dynamic nullSafeFrom(Object object) {
        return object != null ? Dynamics.from(object) : Dynamics.null_();
    }

    @Constant
    public static Dynamic null_() {
        return NULL;
    }

    public static Dynamic fromClassName(@NonNull String classname) {
        Ensure.isNotNull((String)"var0", (Object)classname);
        return Dynamics.from(Classes.newInstance(classname));
    }

    @NonNull
    public static Dynamic fromClass(@NonNull Class<?> clazz) {
        Ensure.isNotNull((String)"var0", clazz);
        return Dynamics.from(Classes.newInstance(clazz));
    }

    @NonNull
    public static Dynamic fromClass(@NonNull Class<?> clazz, Object ... args) {
        Ensure.isNotNull((String)"var0", clazz);
        return Dynamics.from(Classes.newInstance(clazz, args));
    }
}

