/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.dynamic.internal;

import java.util.Arrays;

public final class MethodDescriptor {
    private final Class<?> receptor;
    private final String selector;
    private final Class<?>[] argTypes;

    public MethodDescriptor(Class<?> receptor, String name, Class<?>[] argTypes) {
        this.receptor = receptor;
        this.selector = name;
        this.argTypes = argTypes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.argTypes);
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        result = 31 * result + (this.receptor == null ? 0 : this.receptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        if (!Arrays.equals(this.argTypes, other.argTypes)) {
            return false;
        }
        if (this.selector == null ? other.selector != null : !this.selector.equals(other.selector)) {
            return false;
        }
        return !(this.receptor == null ? other.receptor != null : !this.receptor.equals(other.receptor));
    }

    public String getSelector() {
        return this.selector;
    }

    public Class<?>[] getArgTypes() {
        return this.argTypes;
    }

    public String createNotUnderstoodMessage() {
        return String.format("Message %s(%s) not understood by instance of class %s", this.selector, MethodDescriptor.toString(this.argTypes), this.receptor);
    }

    private static String toString(Class<?>[] argumentTypes) {
        if (argumentTypes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(argumentTypes[0].getName());
        int i = 1;
        while (i < argumentTypes.length) {
            sb.append(", ");
            sb.append(argumentTypes[i].getName());
            ++i;
        }
        return sb.toString();
    }
}

