/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.dynamic.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.staccatocommons.dynamic.internal.PrimitiveWrappers;

public class Methods {
    public static Method findMethod(Class initialClazz, String selector, Class<?>[] argsTypes) {
        Class c = initialClazz;
        while (c != null) {
            Method[] methodArray = c.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (Methods.isDesiredMethod(selector, m, argsTypes)) {
                    return m;
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    public static Constructor findConstructor(Class clazz, Class<?>[] argsTypes) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (Methods.isDesiredConstructor(constructor, argsTypes)) {
                return constructor;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isDesiredMethod(String selector, Method method, Class<?>[] argTypes) {
        return Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == argTypes.length && method.getName().equals(selector) && Methods.argTypesMatch(argTypes, method.getParameterTypes());
    }

    private static boolean isDesiredConstructor(Constructor constructor, Class<?>[] argTypes) {
        return Modifier.isPublic(constructor.getModifiers()) && constructor.getParameterTypes().length == argTypes.length && Methods.argTypesMatch(argTypes, constructor.getParameterTypes());
    }

    private static boolean argTypesMatch(Class<?>[] passedArgTypes, Class<?>[] actualArgTypes) {
        int i = 0;
        while (i < passedArgTypes.length) {
            Class<?> actual = actualArgTypes[i];
            Class<?> passed = passedArgTypes[i];
            if (!actual.isAssignableFrom(passed) && !PrimitiveWrappers.isPrimitiveWrapperFor(actual, passed)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Class<?>[] getArgTypes(Object[] args) {
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return parameterTypes;
    }
}

