/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.dynamic.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.dynamic.AbstractDynamic;
import net.sf.staccatocommons.dynamic.Dynamic;
import net.sf.staccatocommons.dynamic.Dynamics;
import net.sf.staccatocommons.dynamic.MessageNotUnderstoodException;
import net.sf.staccatocommons.dynamic.MethodEvaluationException;
import net.sf.staccatocommons.dynamic.internal.MethodDescriptor;
import net.sf.staccatocommons.dynamic.internal.Methods;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.EnforceRestrictions;

public final class ReflectiveDynamic
extends AbstractDynamic {
    private final Object target;
    private static final Map<MethodDescriptor, Method> CACHE = Collections.synchronizedMap(new WeakHashMap());

    public ReflectiveDynamic(@NonNull Object target) {
        this.target = target;
    }

    @Override
    @EnforceRestrictions
    public <T> T send(@NonNull String selector, Object ... args) {
        Ensure.isNotNull((String)"var1", (Object)args);
        Ensure.isNotNull((String)"var0", (Object)selector);
        MethodDescriptor descriptor = this.newDescriptor(selector, Methods.getArgTypes(args));
        Method method = this.getMethod(descriptor);
        if (method != null) {
            return this.invoke(method, args);
        }
        throw new MessageNotUnderstoodException(descriptor);
    }

    @Override
    public Dynamic chainingSend(String selector, Object ... args) {
        Method method = this.getMethod(this.newDescriptor(selector, Methods.getArgTypes(args)));
        if (method != null) {
            return Dynamics.nullSafeFrom(this.invoke(method, args));
        }
        return Dynamics.null_();
    }

    @Override
    public Object value() {
        return this.target;
    }

    private Method getMethod(MethodDescriptor key) {
        Method method = CACHE.get(key);
        if (method != null) {
            return method;
        }
        method = Methods.findMethod(this.target.getClass(), key.getSelector(), key.getArgTypes());
        if (method == null) {
            return null;
        }
        CACHE.put(key, method);
        return method;
    }

    private MethodDescriptor newDescriptor(String selector, Class<?> ... argTypes) {
        MethodDescriptor key = new MethodDescriptor(this.target.getClass(), selector, argTypes);
        return key;
    }

    private <T> T invoke(Method method, Object ... args) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (T)method.invoke(this.target, args);
        }
        catch (IllegalAccessException e) {
            throw new MethodEvaluationException(e);
        }
        catch (InvocationTargetException e) {
            throw new MethodEvaluationException(e.getCause());
        }
    }
}

