/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lambda;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.check.Validate;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.function.Function3;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.defs.predicate.Predicate2;
import net.sf.staccatocommons.lambda.internal.Unchecker;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.function.AbstractFunction3;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate2;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.EnforceRestrictions;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.ProxyFactory;
import org.apache.commons.proxy.invoker.NullInvoker;

public final class LambdaFactory {
    private static final Validate<IllegalStateException> STATE = Validate.throwing(IllegalStateException.class);
    private final ProxyFactory proxyFactory;
    private final Handler handler;
    private boolean firstStep;

    public LambdaFactory(@NonNull ProxyFactory proxyFactory) {
        Ensure.isNotNull((String)"var0", (Object)proxyFactory);
        this.handler = new Handler();
        this.firstStep = false;
        this.proxyFactory = proxyFactory;
    }

    @EnforceRestrictions
    @NonNull
    public <A> A $(@NonNull Class<A> clazz) {
        Ensure.isNotNull((String)"var0", clazz);
        STATE.that(!this.firstStep, "Wrong invocation order", new Object[0]);
        Object stub = this.proxyFactory.createInvokerProxy((Invoker)this.handler, new Class[]{clazz});
        this.firstStep = true;
        return (A)stub;
    }

    @NonNull
    public <A> Predicate<A> lambda(boolean returnType) {
        final Method method = this.handler.getMethod();
        final Object[] args = this.handler.getArgs();
        return new AbstractPredicate<A>(){

            public boolean eval(Object argument) {
                return (Boolean)LambdaFactory.this.invoke(method, argument, args);
            }
        };
    }

    @NonNull
    public <A, B> Function<A, B> lambda(B returnType) {
        final Method method = this.handler.getMethod();
        final Object[] args = this.handler.getArgs();
        return new AbstractFunction<A, B>(){

            public B apply(Object receptor) {
                return LambdaFactory.this.invoke(method, receptor, args);
            }
        };
    }

    @NonNull
    public <A, B, C> Function2<A, B, C> lambda2(C returnType) {
        final Method method = this.handler.getMethod();
        final Object[] args = this.handler.getArgsCopy();
        args[0] = null;
        return new AbstractFunction2<A, B, C>(){

            public C apply(Object arg0, Object arg1) {
                args[0] = arg1;
                return LambdaFactory.this.invoke(method, arg0, args);
            }
        };
    }

    @NonNull
    public <A, B> Predicate2<A, B> lambda2(boolean returnType) {
        final Method method = this.handler.getMethod();
        final Object[] args = this.handler.getArgsCopy();
        args[0] = null;
        return new AbstractPredicate2<A, B>(){

            public boolean eval(Object arg0, Object arg1) {
                args[0] = arg1;
                return (Boolean)LambdaFactory.this.invoke(method, arg0, args);
            }
        };
    }

    public <A, B, C, D> Function3<A, B, C, D> lambda3(D returnType) {
        final Method method = this.handler.getMethod();
        final Object[] args = this.handler.getArgsCopy();
        args[0] = null;
        args[1] = null;
        return new AbstractFunction3<A, B, C, D>(){

            public D apply(Object arg0, Object arg1, Object arg2) {
                args[0] = arg1;
                args[1] = arg2;
                return LambdaFactory.this.invoke(method, arg0, args);
            }
        };
    }

    private <T> T invoke(Method method, Object receptor, Object[] args) {
        try {
            return (T)method.invoke(receptor, args);
        }
        catch (IllegalAccessException e) {
            throw SoftException.soften((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Unchecker.throwUnchecked(e.getCause());
            return null;
        }
    }

    private final class Handler
    extends NullInvoker {
        private Method method;
        private Object[] args;

        private Handler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.method = method;
            this.args = args;
            return super.invoke(proxy, method, args);
        }

        public Method getMethod() {
            STATE.that(LambdaFactory.this.firstStep, "Wrong invocation order", new Object[0]);
            LambdaFactory.this.firstStep = false;
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Object[] getArgsCopy() {
            return Arrays.copyOf(this.args, this.args.length);
        }
    }
}

