/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.util;

import java.util.regex.Pattern;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.internal.TopLevelFunction;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.lang.predicate.internal.ContainsSubstringPredicate;
import net.sf.staccatocommons.lang.predicate.internal.EqualsIgnoreCase;
import net.sf.staccatocommons.lang.predicate.internal.Matches;
import net.sf.staccatocommons.lang.predicate.internal.TopLevelPredicate;
import net.sf.staccatocommons.lang.value.NamedTupleToStringStyle;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.util.Strings;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Strings {
    private static final Predicate EMPTY = Strings.emptyInitializer();
    private static final Predicate NOT_EMPTY = Strings.notEmptyInitializer();
    private static final Function LENGTH = Strings.lengthInitializer();
    private static final Function TO_STRING_ = Strings.toString_Initializer();

    public static Predicate<String> equalsIgnoreCase(@NonNull String value) {
        Ensure.isNotNull((String)"var0", (Object)value);
        return new EqualsIgnoreCase(value);
    }

    public static Predicate<String> matches(@NonNull String regexp) {
        Ensure.isNotNull((String)"var0", (Object)regexp);
        return new Matches(regexp);
    }

    public static Predicate<String> matches(@NonNull Pattern pattern) {
        Ensure.isNotNull((String)"var0", (Object)pattern);
        return new Matches(pattern);
    }

    public static Predicate<String> contains(@NonNull CharSequence substring) {
        Ensure.isNotNull((String)"var0", (Object)substring);
        return new ContainsSubstringPredicate(substring);
    }

    public static Predicate<String> startsWith(@NonNull String string) {
        Ensure.isNotNull((String)"var0", (Object)string);
        class StartsWith
        extends AbstractPredicate<String> {
            private final /* synthetic */ String val$string;

            StartsWith(String string) {
                this.val$string = string;
            }

            public boolean eval(String args) {
                return args.startsWith(this.val$string);
            }
        }
        return new StartsWith(string);
    }

    @Constant
    public static Predicate<String> empty() {
        return EMPTY;
    }

    @Constant
    public static Predicate<String> notEmpty() {
        return NOT_EMPTY;
    }

    @Constant
    public static Function<CharSequence, Integer> length() {
        return LENGTH;
    }

    @Constant
    public static <A> Function<A, String> toString_() {
        return TO_STRING_;
    }

    public static <A> Function<A, String> reflectionToString(final ToStringStyle toStringStyle) {
        return new AbstractFunction<A, String>(){

            public String apply(A arg) {
                return ToStringBuilder.reflectionToString(arg, (ToStringStyle)toStringStyle);
            }
        };
    }

    public static <A> Function<A, String> reflectionToString() {
        return Strings.reflectionToString(NamedTupleToStringStyle.getInstance());
    }

    private static Predicate emptyInitializer() {
        class EmptyStringPredicate
        extends TopLevelPredicate<String> {
            private static final long serialVersionUID = -7092542419751229862L;

            EmptyStringPredicate() {
            }

            public boolean eval(String argument) {
                return argument.isEmpty();
            }
        }
        return new EmptyStringPredicate();
    }

    private static Predicate notEmptyInitializer() {
        class NotEmptyPredicate
        extends TopLevelPredicate<String> {
            private static final long serialVersionUID = -6617185455944513316L;

            NotEmptyPredicate() {
            }

            public boolean eval(String argument) {
                return !argument.isEmpty();
            }
        }
        return new NotEmptyPredicate();
    }

    private static Function lengthInitializer() {
        class StringLengthFunction
        extends TopLevelFunction<CharSequence, Integer> {
            private static final long serialVersionUID = -1564325023701893305L;

            StringLengthFunction() {
            }

            public Integer apply(CharSequence arg) {
                return arg.length();
            }
        }
        return new StringLengthFunction();
    }

    private static Function toString_Initializer() {
        return new AbstractFunction<A, String>(){

            public String apply(A arg) {
                return arg.toString();
            }
        };
    }
}

