/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statscm;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.logging.Log;

class ConsoleFileStream
extends Thread {
    private Log log;
    private File file;
    private InputStream is;

    ConsoleFileStream(InputStream inputStream, File outputFile, Log logger) {
        this.is = inputStream;
        this.file = outputFile;
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FileOutputStream fos = null;
        try {
            DataInputStream dis = new DataInputStream(this.is);
            fos = new FileOutputStream(this.file, false);
            while (true) {
                fos.write(dis.readByte());
            }
        }
        catch (EOFException eofe) {
            this.log.info((CharSequence)(this.file.toString() + " EOF."));
            try {
                fos.close();
            }
            catch (IOException e) {
                this.log.error((CharSequence)e.getMessage(), (Throwable)e);
                fos = null;
            }
        }
        catch (IOException ioe) {
            try {
                this.log.error((CharSequence)ioe.getMessage(), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.log.error((CharSequence)e.getMessage(), (Throwable)e);
                    fos = null;
                }
            }
        }
    }
}

