/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statscm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.statcvs.Messages;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.output.CommandLineParser;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statscm.SrcManager;
import net.sf.statscm.StatConf;
import net.sf.statsvn.Main;
import net.sf.statsvn.output.SvnCommandLineParser;
import net.sf.statsvn.output.SvnConfigurationOptions;
import net.sf.statsvn.util.SvnStartupUtils;
import net.sf.statsvn.util.SvnVersionMismatchException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Reporting;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

public class StatScmMojo
extends AbstractMavenReport {
    private MavenProject project;
    private String[] includes;
    private String[] excludes;
    private String[] nonDeveloperLogins;
    private String cacheDir;
    private String notesFile;
    private boolean skip;
    private String title;
    private StatConf statConf = new StatConf();

    public void execute() {
        this.getLog().error((CharSequence)"StatSCM can not be run directly!");
        this.getLog().info((CharSequence)"Configure it to run with the \"mvn site\" command.");
        this.getLog().info((CharSequence)"See: http://sourceforge.net/tracker/index.php?func=detail&aid=1610964&group_id=182522&atid=901553.");
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (this.skip) {
            this.getLog().info((CharSequence)this.getMessage("info.greeting.skip"));
        } else {
            this.getLog().info((CharSequence)this.getMessage("info.greeting.ok"));
            try {
                this.getLog().info((CharSequence)("StatSCM Version:" + this.getStatSCMVersion()));
                this.getLog().info((CharSequence)"Configuring StatXXX");
                this.statConf.configure(this.project, locale);
                this.configFromMojoProperties();
                this.getLog().info((CharSequence)("SCM Connection Type :" + this.statConf.getConnectionType()));
                this.getLog().info((CharSequence)("Output Directory    :" + this.getOutputDirectory()));
            }
            catch (ConfigurationException e) {
                this.getLog().error((CharSequence)this.getMessage("error.config"), (Throwable)e);
                return;
            }
            SrcManager scm = new SrcManager();
            if (!scm.log(this.statConf.getBaseDirectory(), this.getLog(), this.statConf)) {
                this.getLog().error((CharSequence)this.getMessage("error.scmlog.file_missing"));
                return;
            }
            if (!this.createOutputDirectory()) {
                this.getLog().error((CharSequence)this.getMessage("error.ouput.can_not_create_output_folder"));
                return;
            }
            try {
                if (this.statConf.isStatSVN() || this.statConf.isStatCVS()) {
                    if (this.statConf.isStatSVN()) {
                        this.doSvnStats();
                    } else if (this.statConf.isStatCVS()) {
                        this.doCvsStats();
                    }
                    this.doGenerateReport(this.getSink());
                    this.copyResourceFiles(this.getOutputDirectory(), this.getReportingTargetDirectory());
                } else {
                    this.getLog().error((CharSequence)this.getMessage("warn.scm.type_xxx"));
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)this.getMessage("error.config"), (Throwable)e);
            }
        }
    }

    private void doSvnStats() throws MavenReportException {
        Messages.setPrimaryResource((String)"net.sf.statsvn.statcvs");
        try {
            Messages.setPrimaryResource((String)"net.sf.statsvn.statcvs");
            new SvnCommandLineParser(new String[]{StatConf.getLogFileName(), "."}).parse();
            SvnStartupUtils.checkSvnVersionSufficient();
            SvnStartupUtils.checkRepoRootAvailable();
            Main.generateDefaultHTMLSuite();
        }
        catch (LogSyntaxException e) {
            this.getLog().error((CharSequence)this.getMessage("error.scmlog.parsing"), (Throwable)e);
            throw new MavenReportException(e.getMessage());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error generating Subversion Stats.", (Throwable)e);
            throw new MavenReportException(e.getMessage());
        }
        catch (ConfigurationException e) {
            this.getLog().error((CharSequence)this.getMessage("error.config"), (Throwable)e);
            throw new MavenReportException(e.getMessage());
        }
        catch (SvnVersionMismatchException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MavenReportException(e.getMessage());
        }
        catch (NullPointerException e) {
            this.getLog().warn((CharSequence)"Null Pointer: Sometimes happens when local files are not synced with the repository!");
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    private void doCvsStats() throws MavenReportException {
        try {
            new CommandLineParser(new String[]{StatConf.getLogFileName(), "."}).parse();
            net.sf.statcvs.Main.generateDefaultHTMLSuite();
        }
        catch (LogSyntaxException e) {
            this.getLog().error((CharSequence)this.getMessage("error.scmlog.parsing"), (Throwable)e);
            throw new MavenReportException(e.getMessage());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error generating Subversion Stats.", (Throwable)e);
            throw new MavenReportException(e.getMessage());
        }
        catch (ConfigurationException e) {
            this.getLog().error((CharSequence)this.getMessage("error.config"), (Throwable)e);
            throw new MavenReportException(e.getMessage());
        }
    }

    private boolean createOutputDirectory() {
        File outputDir = new File(this.getOutputDirectory());
        if (outputDir.exists()) {
            if (outputDir.isDirectory()) {
                return true;
            }
            this.getLog().error((CharSequence)(this.getMessage("error.outputDir.file_in_the_way") + outputDir.getAbsolutePath()));
            return false;
        }
        if (outputDir.mkdirs()) {
            return true;
        }
        this.getLog().error((CharSequence)("Can  not make output directory at: " + outputDir.getAbsolutePath()));
        return false;
    }

    private void configFromMojoProperties() throws ConfigurationException {
        this.configIncludeExclude();
        this.configNonDeveloperLogins();
        this.configCacheSettings();
        this.configNotesFile();
        this.configTitle();
    }

    private void configTitle() {
        if (this.title != null) {
            String projectName = this.title.trim();
            if (projectName.length() > 0) {
                StatConf.setProjectName((String)projectName);
            }
            StatScmMojo statScmMojo = this;
            this.getLog().info((CharSequence)("Page title: " + statScmMojo.statConf.getProjectName()));
        }
    }

    private void configNotesFile() throws ConfigurationException {
        String filename;
        if (this.notesFile != null && (filename = this.notesFile.trim()).length() > 0) {
            try {
                StatConf.setNotesFile((String)filename);
                this.getLog().info((CharSequence)("Notes file: " + filename));
            }
            catch (ConfigurationException e) {
                this.getLog().info((CharSequence)("Notes file: " + filename));
                throw e;
            }
        }
    }

    private void configCacheSettings() throws ConfigurationException {
        String dir;
        if (this.cacheDir != null && (dir = this.cacheDir.trim()).length() > 0) {
            try {
                SvnConfigurationOptions.setCacheDir((String)dir);
                this.getLog().info((CharSequence)("Cache directory: " + dir));
            }
            catch (ConfigurationException e) {
                this.getLog().info((CharSequence)("Cache directory: " + dir));
                throw e;
            }
        }
    }

    private void configIncludeExclude() {
        String patternList = this.buildIncludeExcludeString(this.includes);
        if (patternList.length() > 0) {
            StatConf.setIncludePattern((String)patternList);
            this.getLog().info((CharSequence)("Includes: " + patternList));
        } else {
            this.getLog().info((CharSequence)"Include all");
        }
        patternList = this.buildIncludeExcludeString(this.excludes);
        if (patternList.length() > 0) {
            StatConf.setExcludePattern((String)patternList);
            this.getLog().info((CharSequence)("Excludes: " + patternList));
        } else {
            this.getLog().info((CharSequence)"Exclude none");
        }
    }

    protected String buildIncludeExcludeString(String[] list) {
        StringBuffer patternList = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String include = list[i].trim();
                if (include.indexOf(59) > 0) {
                    this.getLog().warn((CharSequence)(this.getMessage("warn.config.include.exclude.delimiter.1") + " ':' " + this.getMessage("warn.config.include.exclude.delimiter.2") + include));
                }
                if (include.indexOf(58) > 0) {
                    this.getLog().warn((CharSequence)(this.getMessage("warn.config.include.exclude.delimiter.1") + " ';' " + this.getMessage("warn.config.include.exclude.delimiter.2") + include));
                }
                if (include.length() <= 0) continue;
                if (patternList.length() > 0) {
                    patternList.append(';');
                }
                patternList.append(list[i]);
            }
        }
        return patternList.toString();
    }

    private void configNonDeveloperLogins() {
        if (this.nonDeveloperLogins != null) {
            for (int i = 0; i < this.nonDeveloperLogins.length; ++i) {
                String login = this.nonDeveloperLogins[i].trim();
                if (login.length() <= 0) continue;
                StatConf.addNonDeveloperLogin((String)login);
                this.getLog().info((CharSequence)("Non-developer login: " + login));
            }
        }
    }

    protected Renderer getSiteRenderer() {
        return null;
    }

    protected String getOutputDirectory() {
        return StatConf.getOutputDir();
    }

    protected String getReportingTargetDirectory() {
        String targetBaseDirectory = null;
        Reporting reporting = this.getProject().getReporting();
        if (reporting != null) {
            targetBaseDirectory = reporting.getOutputDirectory();
        }
        if (targetBaseDirectory == null) {
            targetBaseDirectory = this.getStatConf().getBaseDirectory().getAbsolutePath() + this.statConf.FILE_SEPARATOR + "target" + this.statConf.FILE_SEPARATOR + "site";
        }
        return targetBaseDirectory + this.statConf.FILE_SEPARATOR + "statscm";
    }

    public String getOutputName() {
        return "statscm/statscm";
    }

    public String getName(Locale locale) {
        return "StatSCM";
    }

    public String getDescription(Locale loc) {
        return this.getMessage("statscm.description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyResourceFiles(String src, String dest) {
        File srcDir = new File(src);
        if (!srcDir.isDirectory()) {
            this.getLog().error((CharSequence)("Can not copy reources src is not a directory: " + srcDir.getAbsolutePath()));
            return;
        }
        File destDir = new File(dest);
        if (!destDir.isDirectory()) {
            destDir.mkdirs();
        }
        String[] resoures = srcDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String[] extensions = new String[]{".png", ".jar", ".txt"};
                String fileName = name.toLowerCase(Locale.getDefault());
                for (int i = 0; i < extensions.length; ++i) {
                    if (!fileName.endsWith(extensions[i])) continue;
                    return true;
                }
                return false;
            }
        });
        int i = 0;
        while (i < resoures.length) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(new File(src + this.statConf.FILE_SEPARATOR + resoures[i]));
                fos = new FileOutputStream(new File(dest + this.statConf.FILE_SEPARATOR + resoures[i]));
                int b = -1;
                while ((b = fis.read()) != -1) {
                    fos.write(b);
                }
                fis.close();
                fos.close();
            }
            catch (FileNotFoundException e) {
                this.getLog().error((CharSequence)("Can not find file " + resoures[i]), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error copying file: " + src + "/" + resoures[i]), (Throwable)e);
            }
            finally {
                try {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        fis = null;
                        fos = null;
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)"I/O Exception copying resources.", (Throwable)e);
                        fis = null;
                        fos = null;
                    }
                }
                catch (Throwable throwable) {
                    fis = null;
                    fos = null;
                    throw throwable;
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Copied file " + src + this.statConf.FILE_SEPARATOR + resoures[i] + " to " + dest + this.statConf.FILE_SEPARATOR + resoures[i]));
            }
            ++i;
        }
        return;
    }

    private void doGenerateReport(Sink sink) {
        if (sink == null) {
            return;
        }
        sink.head();
        sink.title();
        sink.text("StatSCM");
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.getDescription(Locale.getDefault()));
        sink.sectionTitle1_();
        sink.bold();
        sink.link("index.html");
        sink.text("Main page");
        sink.link_();
        sink.bold_();
        sink.lineBreak();
        sink.link("index.html");
        sink.figure();
        sink.figureGraphics("loc.png");
        sink.figure_();
        sink.link_();
        sink.lineBreak();
        sink.text("Generated using ");
        sink.link("http://stat-scm.sourceforge.net/");
        sink.text("StatSCM" + this.getStatSCMVersion());
        sink.link_();
        sink.text(".");
        sink.flush();
        sink.close();
    }

    private String getStatSCMVersion() {
        String versionText = this.getMessage("statscm.version");
        if (versionText == null) {
            return "";
        }
        if (versionText.equals("${pom.version}")) {
            return "";
        }
        return " (" + versionText + ")";
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getMessage(String messageKey) {
        return ResourceBundle.getBundle("net.sf.statscm.message", this.statConf.getLocale()).getString(messageKey);
    }

    public StatConf getStatConf() {
        return this.statConf;
    }

    public void setStatConf(StatConf statConf) {
        this.statConf = statConf;
    }

    void setSkipParameter(boolean b) {
        this.skip = b;
    }
}

