/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statscm;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.weblinks.bugs.BugTracker;

public class Trac
extends BugTracker
implements WebRepositoryIntegration {
    protected static Pattern bugRegex = Pattern.compile("(?:#\\s*)?(\\d+)");
    private Set atticFileNames = new HashSet();

    public Trac(String baseURL) {
        super(baseURL);
    }

    public String getName() {
        return "Trac";
    }

    public String bugURL(String bugNumber) {
        return this.baseURL() + "ticket/" + bugNumber;
    }

    public String toHTMLWithLinks(String plainTextInput) {
        if (this.baseURL() == null || this.baseURL().length() == 0) {
            return HTML.escape((String)plainTextInput);
        }
        StringBuffer result = new StringBuffer();
        Matcher m = bugRegex.matcher(plainTextInput);
        int offset = 0;
        while (m.find()) {
            String linkLabel = m.group();
            String bugNumber = m.group(1);
            String bugURL = this.bugURL(bugNumber);
            result.append(HTML.escape((String)plainTextInput.substring(offset, m.start())));
            if (bugURL == null) {
                result.append(HTML.escape((String)linkLabel));
            } else {
                result.append(HTML.getLink((String)bugURL, (String)linkLabel, (String)HTML.getIcon((String)"bug.png", (String)Messages.getString((String)"BUG_ICON")), (String)""));
            }
            offset = m.end();
        }
        result.append(HTML.escape((String)plainTextInput.substring(offset, plainTextInput.length())));
        return result.toString();
    }

    protected String getFileUrl(VersionedFile file) {
        String filename;
        if (this.isInAttic(file)) {
            String path = file.getDirectory().getPath();
            filename = "/" + path + "Attic/" + file.getFilename();
        } else {
            filename = "/" + file.getFilenameWithPath();
        }
        return filename;
    }

    public String getDiffUrl(Revision oldRevision, Revision newRevision) {
        return this.baseURL() + "/changeset/" + oldRevision.getRevisionNumber() + "/" + oldRevision.getFile() + "?old=" + newRevision.getRevisionNumber() + "&oldPath=" + newRevision.getFile();
    }

    public String getDirectoryUrl(Directory directory) {
        return this.baseURL() + "/browser" + directory.getPath();
    }

    public String getFileHistoryUrl(VersionedFile file) {
        return this.baseURL() + "log/" + this.getFileUrl(file);
    }

    public String getFileViewUrl(VersionedFile file) {
        return this.baseURL() + this.getFileUrl(file);
    }

    public String getFileViewUrl(Revision revision) {
        return this.baseURL() + this.getFileUrl(revision.getFile()) + "?rev=" + revision.getRevisionNumber();
    }

    public void setAtticFileNames(Set atticFileNames) {
        this.atticFileNames = atticFileNames;
    }

    protected boolean isInAttic(VersionedFile file) {
        return this.atticFileNames.contains(file.getFilenameWithPath());
    }

    public String getBaseUrl() {
        return super.baseURL();
    }
}

