/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.description.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.action.description.syntax.CActionDescription;
import net.sf.tweety.action.description.syntax.CLaw;
import net.sf.tweety.action.description.syntax.DynamicLaw;
import net.sf.tweety.action.description.syntax.StaticLaw;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.action.grounding.parser.GroundingRequirementsParser;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Parser;
import net.sf.tweety.commons.ParserException;
import net.sf.tweety.logics.commons.syntax.RelationalFormula;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.fol.parser.FolParser;
import net.sf.tweety.logics.fol.syntax.AssociativeFolFormula;
import net.sf.tweety.logics.fol.syntax.Conjunction;
import net.sf.tweety.logics.fol.syntax.Contradiction;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.logics.fol.syntax.Negation;
import net.sf.tweety.logics.fol.syntax.Tautology;

public class CLawParser
extends Parser<CActionDescription, Formula> {
    protected ActionSignature signature;

    public CLawParser(ActionSignature signature) {
        this.signature = signature;
    }

    public CActionDescription parseBeliefBase(Reader reader) throws ParserException {
        CActionDescription actionDescription = new CActionDescription();
        Object s = "";
        try {
            int c;
            do {
                if ((c = reader.read()) == 10 || c == -1) {
                    if (!((String)s).equals("") && !((String)s).trim().startsWith("%")) {
                        actionDescription.add((CLaw)this.parseFormula((String)s));
                    }
                    s = "";
                    continue;
                }
                s = (String)s + (char)c;
            } while (c != -1);
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
        return actionDescription;
    }

    public Formula parseFormula(Reader reader) throws IOException, ParserException {
        int c;
        Object s = "";
        do {
            c = reader.read();
            s = (String)s + (char)c;
        } while (c != -1);
        return this.parseFormula((String)s);
    }

    protected FolFormula parseFolFormula(String s) throws ParserException, IOException {
        FolParser p = new FolParser();
        p.setSignature((FolSignature)this.signature);
        return (FolFormula)p.parseFormula(s);
    }

    public Formula parseFormula(String s) throws ParserException, IOException {
        s = s.trim();
        String reqString = null;
        if (s.contains(" requires ")) {
            reqString = s.substring(s.indexOf(" requires ") + 10);
            Set<String> wrongKey = this.containedKeywords(reqString);
            if (!wrongKey.isEmpty()) {
                throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use.");
            }
            s = s.substring(0, s.indexOf(" requires "));
        }
        if (s.startsWith("caused ")) {
            return this.parseCausedFormula(s, reqString);
        }
        if (s.startsWith("inertial ")) {
            return this.parseInertialFormula(s, reqString);
        }
        if (s.startsWith("default ")) {
            return this.parseDefaultFormula(s, reqString);
        }
        if (s.startsWith("always ")) {
            return this.parseAlwaysFormula(s, reqString);
        }
        if (s.startsWith("nonexecutable ")) {
            return this.parseNonexecutableFormula(s, reqString);
        }
        if (s.contains(" causes ")) {
            return this.parseCausesFormula(s, reqString);
        }
        if (s.contains(" may cause ")) {
            return this.parseMayCauseFormula(s, reqString);
        }
        throw new ParserException("Unsupported causal law: " + s);
    }

    private Formula parseCausedFormula(String s, String reqString) throws ParserException, IOException {
        String headString;
        Set<String> wrongKey;
        if (!s.startsWith("caused ")) {
            throw new ParserException("Missing 'caused' expression in causal law: " + s);
        }
        FolFormula afterFormula = null;
        FolFormula ifFormula = null;
        FolFormula headFormula = null;
        if (s.contains(" after ")) {
            String afterString = s.substring(s.indexOf(" after ") + 7);
            wrongKey = this.containedKeywords(afterString);
            if (!wrongKey.isEmpty()) {
                throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use.");
            }
            afterFormula = this.parseFolFormula(afterString);
            s = s.substring(0, s.indexOf(" after "));
        }
        if (s.contains(" if ")) {
            String ifString = s.substring(s.indexOf(" if ") + 4);
            wrongKey = this.containedKeywords(ifString);
            if (!wrongKey.isEmpty()) {
                throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use.");
            }
            ifFormula = this.parseFolFormula(ifString);
            s = s.substring(0, s.indexOf(" if "));
        }
        if (!(wrongKey = this.containedKeywords(headString = s.substring(s.indexOf("caused ") + 7))).isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        headFormula = this.parseFolFormula(headString);
        HashSet<Variable> variables = new HashSet<Variable>();
        variables.addAll(headFormula.getUnboundVariables());
        if (ifFormula != null) {
            variables.addAll(ifFormula.getUnboundVariables());
        }
        if (afterFormula != null) {
            variables.addAll(afterFormula.getUnboundVariables());
        }
        Set<GroundingRequirement> requirements = null;
        requirements = new GroundingRequirementsParser().parseRequirements(reqString, variables);
        if (afterFormula != null) {
            return new DynamicLaw(headFormula, ifFormula, afterFormula, requirements);
        }
        return new StaticLaw(headFormula, ifFormula, requirements);
    }

    private Formula parseInertialFormula(String s, String reqString) throws ParserException, IOException {
        if (!s.startsWith("inertial ")) {
            throw new ParserException("Missing 'inertial' expression in causal law: " + s);
        }
        FolFormula formula = null;
        String headString = s.substring(s.indexOf("inertial ") + 9);
        Set<String> wrongKey = this.containedKeywords(headString);
        if (!wrongKey.isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        formula = this.parseFolFormula(headString);
        if (formula instanceof AssociativeFolFormula) {
            throw new ParserException("Inertial expression contains illegal argument.");
        }
        if (formula instanceof Negation && !(((Negation)formula).getFormula() instanceof FolAtom)) {
            throw new ParserException("Inertial expression contains illegal argument.");
        }
        Set<GroundingRequirement> requirements = null;
        requirements = new GroundingRequirementsParser().parseRequirements(reqString, formula.getUnboundVariables());
        return new DynamicLaw(formula, formula, formula, requirements);
    }

    private Formula parseDefaultFormula(String s, String reqString) throws ParserException, IOException {
        String headString;
        Set<String> wrongKey;
        if (!s.startsWith("default ")) {
            throw new ParserException("Missing 'default' expression in causal law: " + s);
        }
        FolFormula ifFormula = null;
        FolFormula headFormula = null;
        if (s.contains(" if ")) {
            String ifString = s.substring(s.indexOf(" if ") + 4);
            wrongKey = this.containedKeywords(ifString);
            if (!wrongKey.isEmpty()) {
                throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use.");
            }
            ifFormula = this.parseFolFormula(ifString);
            s = s.substring(0, s.indexOf(" if "));
        }
        if (!(wrongKey = this.containedKeywords(headString = s.substring(s.indexOf("default ") + 8))).isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        headFormula = this.parseFolFormula(headString);
        HashSet<Variable> variables = new HashSet<Variable>();
        variables.addAll(headFormula.getUnboundVariables());
        if (ifFormula != null) {
            variables.addAll(ifFormula.getUnboundVariables());
        }
        Set<GroundingRequirement> requirements = null;
        requirements = new GroundingRequirementsParser().parseRequirements(reqString, variables);
        if (ifFormula != null) {
            Conjunction c = new Conjunction();
            c.add((RelationalFormula)headFormula);
            c.add((RelationalFormula)ifFormula);
            return new StaticLaw(headFormula, (FolFormula)c, requirements);
        }
        return new StaticLaw(headFormula, headFormula, requirements);
    }

    private Formula parseCausesFormula(String s, String reqString) throws ParserException, IOException {
        String[] split;
        String headString;
        Set<String> wrongKey;
        if (!s.contains(" causes ")) {
            throw new ParserException("Missing 'causes' expression in causal law: " + s);
        }
        FolFormula headFormula = null;
        FolFormula causesFormula = null;
        FolFormula ifFormula = null;
        if (s.contains(" if ")) {
            String ifString = s.substring(s.indexOf(" if ") + 4);
            Set<String> wrongKey2 = this.containedKeywords(ifString);
            if (!wrongKey2.isEmpty()) {
                throw new ParserException("Unexpected keyword(s) '" + wrongKey2.toString() + "' in formula '" + s + "' due to wrong order or multiple use.");
            }
            ifFormula = this.parseFolFormula(ifString);
            s = s.substring(0, s.indexOf(" if "));
        }
        if (!(wrongKey = this.containedKeywords(headString = (split = s.split(" causes "))[0])).isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        headFormula = this.parseFolFormula(headString);
        String causesString = split[1];
        wrongKey = this.containedKeywords(causesString);
        if (!wrongKey.isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        causesFormula = this.parseFolFormula(causesString);
        HashSet<Variable> variables = new HashSet<Variable>();
        variables.addAll(headFormula.getUnboundVariables());
        variables.addAll(causesFormula.getUnboundVariables());
        if (ifFormula != null) {
            variables.addAll(ifFormula.getUnboundVariables());
        }
        Set<GroundingRequirement> requirements = null;
        requirements = new GroundingRequirementsParser().parseRequirements(reqString, variables);
        if (ifFormula != null) {
            Conjunction c = new Conjunction();
            c.add((RelationalFormula)headFormula);
            c.add((RelationalFormula)ifFormula);
            return new DynamicLaw(causesFormula, (FolFormula)new Tautology(), (FolFormula)c, requirements);
        }
        return new DynamicLaw(causesFormula, (FolFormula)new Tautology(), headFormula, requirements);
    }

    private Formula parseAlwaysFormula(String s, String reqString) throws ParserException, IOException {
        if (!s.startsWith("always ")) {
            throw new ParserException("Missing 'always' expression in causal law: " + s);
        }
        FolFormula headFormula = null;
        Set<String> wrongKey = this.containedKeywords(s);
        if (!wrongKey.isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        headFormula = this.parseFolFormula(s);
        HashSet<Variable> variables = new HashSet<Variable>();
        variables.addAll(headFormula.getUnboundVariables());
        Set<GroundingRequirement> requirements = null;
        requirements = new GroundingRequirementsParser().parseRequirements(reqString, variables);
        return new StaticLaw((FolFormula)new Contradiction(), (FolFormula)new Negation((RelationalFormula)headFormula), requirements);
    }

    private Formula parseNonexecutableFormula(String s, String reqString) throws ParserException, IOException {
        String headString;
        Set<String> wrongKey;
        if (!s.startsWith("nonexecutable ")) {
            throw new ParserException("Missing 'nonexecutable' expression in causal law: " + s);
        }
        FolFormula ifFormula = null;
        FolFormula headFormula = null;
        if (s.contains(" if ")) {
            String ifString = s.substring(s.indexOf(" if ") + 4);
            wrongKey = this.containedKeywords(ifString);
            if (!wrongKey.isEmpty()) {
                throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use.");
            }
            ifFormula = this.parseFolFormula(ifString);
            s = s.substring(0, s.indexOf(" if "));
        }
        if (!(wrongKey = this.containedKeywords(headString = s.substring(s.indexOf("nonexecutable ") + 14))).isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        headFormula = this.parseFolFormula(headString);
        HashSet<Variable> variables = new HashSet<Variable>();
        variables.addAll(headFormula.getUnboundVariables());
        if (ifFormula != null) {
            variables.addAll(ifFormula.getUnboundVariables());
        }
        Set<GroundingRequirement> requirements = null;
        requirements = new GroundingRequirementsParser().parseRequirements(reqString, variables);
        if (ifFormula != null) {
            Conjunction c = new Conjunction();
            c.add((RelationalFormula)headFormula);
            c.add((RelationalFormula)ifFormula);
            return new DynamicLaw((FolFormula)new Contradiction(), (FolFormula)c, requirements);
        }
        return new DynamicLaw((FolFormula)new Contradiction(), headFormula, requirements);
    }

    private Formula parseMayCauseFormula(String s, String reqString) throws ParserException, IOException {
        String[] split;
        String headString;
        Set<String> wrongKey;
        if (!s.contains(" may cause ")) {
            throw new ParserException("Missing 'may cause' expression in causal law: " + s);
        }
        FolFormula headFormula = null;
        FolFormula maycauseFormula = null;
        FolFormula ifFormula = null;
        if (s.contains(" if ")) {
            String ifString = s.substring(s.indexOf(" if ") + 4);
            Set<String> wrongKey2 = this.containedKeywords(ifString);
            if (!wrongKey2.isEmpty()) {
                throw new ParserException("Unexpected keyword(s) '" + wrongKey2.toString() + "' in formula '" + s + "' due to wrong order or multiple use.");
            }
            ifFormula = this.parseFolFormula(ifString);
            s = s.substring(0, s.indexOf(" if "));
        }
        if (!(wrongKey = this.containedKeywords(headString = (split = s.split(" may cause "))[0])).isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        headFormula = this.parseFolFormula(headString);
        String maycauseString = split[1];
        wrongKey = this.containedKeywords(maycauseString);
        if (!wrongKey.isEmpty()) {
            throw new ParserException("Unexpected keyword(s) '" + wrongKey.toString() + "' in formula '" + s + "' due to wrong order or multiple use of keywords.");
        }
        maycauseFormula = this.parseFolFormula(maycauseString);
        HashSet<Variable> variables = new HashSet<Variable>();
        variables.addAll(headFormula.getUnboundVariables());
        variables.addAll(maycauseFormula.getUnboundVariables());
        if (ifFormula != null) {
            variables.addAll(ifFormula.getUnboundVariables());
        }
        Set<GroundingRequirement> requirements = null;
        requirements = new GroundingRequirementsParser().parseRequirements(reqString, variables);
        if (ifFormula != null) {
            Conjunction c = new Conjunction();
            c.add((RelationalFormula)headFormula);
            c.add((RelationalFormula)ifFormula);
            return new DynamicLaw(maycauseFormula, maycauseFormula, (FolFormula)c, requirements);
        }
        return new DynamicLaw(maycauseFormula, maycauseFormula, headFormula, requirements);
    }

    protected Set<String> containedKeywords(String s) {
        String[] keywords = new String[]{"caused ", " if ", " after ", " requires ", "inertial ", "default ", " causes ", "always ", "nonexecutable ", " may cause "};
        HashSet<String> result = new HashSet<String>();
        for (String key : keywords) {
            if (!s.contains(key)) continue;
            result.add(key);
        }
        return result;
    }
}

