/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.description.reasoner;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.description.syntax.CActionDescription;
import net.sf.tweety.action.description.syntax.DynamicLaw;
import net.sf.tweety.action.description.syntax.StaticLaw;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.action.signature.FolAction;
import net.sf.tweety.action.signature.FolActionName;
import net.sf.tweety.action.signature.FolFluentName;
import net.sf.tweety.action.transitionsystem.State;
import net.sf.tweety.action.transitionsystem.Transition;
import net.sf.tweety.action.transitionsystem.TransitionSystem;
import net.sf.tweety.commons.ParserException;
import net.sf.tweety.logics.commons.syntax.RelationalFormula;
import net.sf.tweety.logics.fol.parser.FolParser;
import net.sf.tweety.logics.fol.syntax.Conjunction;
import net.sf.tweety.logics.fol.syntax.Contradiction;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.logics.fol.syntax.Negation;
import net.sf.tweety.logics.fol.syntax.Tautology;
import net.sf.tweety.lp.asp.reasoner.ASPSolver;

public class CTransitionSystemCalculator {
    private ASPSolver aspsolver;

    public CTransitionSystemCalculator(ASPSolver aspsolver) {
        this.aspsolver = aspsolver;
    }

    public TransitionSystem calculateTransitionSystem(CActionDescription actionDescription, ActionSignature signature) throws IOException {
        if (!actionDescription.isDefinite()) {
            throw new IllegalArgumentException("Cannot calculate transition system of non-definite action description.");
        }
        Set<State> states = this.calculateStates(actionDescription, signature);
        if (states == null) {
            return new TransitionSystem(signature);
        }
        TransitionSystem transitionSystem = new TransitionSystem(states, signature);
        String rules = this.getLpT(actionDescription, signature, 1);
        this.aspsolver.getModels(rules);
        String[] claspResult = this.aspsolver.getOutput().split("\\R+");
        if (claspResult == null) {
            return transitionSystem;
        }
        Set<Map<Integer, Set<FolAtom>>> answerSets = this.parseLpT(claspResult, signature);
        for (Map<Integer, Set<FolAtom>> answerSet : answerSets) {
            HashSet<FolAtom> sourceStateFluents = new HashSet<FolAtom>();
            HashSet<FolAtom> targetStateFluents = new HashSet<FolAtom>();
            HashSet<FolAtom> actionNames = new HashSet<FolAtom>();
            for (FolAtom a : answerSet.get(0)) {
                if (a.getPredicate() instanceof FolFluentName) {
                    sourceStateFluents.add(a);
                    continue;
                }
                if (!(a.getPredicate() instanceof FolActionName)) continue;
                actionNames.add(a);
            }
            for (FolAtom a : answerSet.get(1)) {
                targetStateFluents.add(a);
            }
            State sourceState = transitionSystem.getState(sourceStateFluents);
            State targetState = transitionSystem.getState(targetStateFluents);
            FolAction action = new FolAction(actionNames);
            transitionSystem.addTransition(new Transition(sourceState, action, targetState));
        }
        return transitionSystem;
    }

    public Set<State> calculateStates(CActionDescription actionDescription, ActionSignature signature) throws IOException {
        if (!actionDescription.isDefinite()) {
            throw new IllegalArgumentException("Cannot calculate transition system of non-definite action description.");
        }
        HashSet<State> result = new HashSet<State>();
        String rules = this.getLpT(actionDescription, signature, 0);
        this.aspsolver.getModels(rules);
        String[] claspResult = this.aspsolver.getOutput().split("\\R+");
        if (claspResult == null) {
            return null;
        }
        Set<Map<Integer, Set<FolAtom>>> states = this.parseLpT(claspResult, signature);
        for (Map<Integer, Set<FolAtom>> state : states) {
            State s = new State(state.get(0));
            result.add(s);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public String getLpT(CActionDescription d, ActionSignature signature, int T) {
        int t;
        if (T < 0) {
            throw new IllegalArgumentException("T has to be >= 0.");
        }
        if (!d.isDefinite()) {
            throw new IllegalArgumentException("Cannot calculate transition system of non-definite action description.");
        }
        Object result = "";
        Set<FolAtom> groundedFluentAtoms = signature.getAllGroundedFluentAtoms();
        for (StaticLaw staticLaw : d.getStaticLaws()) {
            for (t = 0; t <= T; ++t) {
                result = (String)result + this.getLiteralString(staticLaw.getHeadFormula(), t, false);
                if (!(staticLaw.getIfFormula() instanceof Tautology)) {
                    result = (String)result + " :- ";
                    result = (String)result + this.getRuleBodyString(staticLaw.getIfFormula(), t, true);
                }
                result = (String)result + ".\n";
            }
        }
        result = (String)result + this.getDefaultNegationRules(groundedFluentAtoms, 0);
        if (T > 0) {
            void var7_13;
            void var7_11;
            for (DynamicLaw dynamicLaw : d.getDynamicLaws()) {
                for (t = 0; t < T; ++t) {
                    result = (String)result + this.getLiteralString(dynamicLaw.getHeadFormula(), t + 1, false);
                    result = (String)result + " :- ";
                    if (!(dynamicLaw.getIfFormula() instanceof Tautology)) {
                        result = (String)result + this.getRuleBodyString(dynamicLaw.getIfFormula(), t + 1, true);
                        result = (String)result + ",";
                    }
                    result = (String)result + this.getRuleBodyString(dynamicLaw.getAfterFormula(), t, false);
                    result = (String)result + ".\n";
                }
            }
            Set<FolAtom> groundedActionNames = signature.getAllGroundedActionNameAtoms();
            boolean bl = false;
            while (var7_11 < T) {
                result = (String)result + this.getDefaultNegationRules(groundedActionNames, (int)var7_11);
                ++var7_11;
            }
            boolean bl2 = true;
            while (var7_13 <= T) {
                result = (String)result + this.getCompletenessEnforcementRules(groundedFluentAtoms, (int)var7_13);
                ++var7_13;
            }
        }
        return result;
    }

    private String getDefaultNegationRules(Set<FolAtom> atoms, int t) {
        Object rules = "";
        for (FolAtom a : atoms) {
            String atomName = this.getAtomString((RelationalFormula)a, t);
            rules = (String)rules + "-" + atomName + " :- not " + atomName + ".\n";
            rules = (String)rules + atomName + " :- not -" + atomName + ".\n";
        }
        return rules;
    }

    private String getCompletenessEnforcementRules(Set<FolAtom> atoms, int t) {
        Object rules = "";
        for (FolAtom a : atoms) {
            String atomName = this.getAtomString((RelationalFormula)a, t);
            rules = (String)rules + ":- not " + atomName + ", not -" + atomName + ".\n";
        }
        return rules;
    }

    private String removeIllegalChars(String s) {
        return s.replace("(", "xxx1xxx").replace(")", "xxx2xxx").replace(",", "xxx3xxx");
    }

    private String regainIllegalChars(String s) {
        return s.replace("xxx1xxx", "(").replace("xxx2xxx", ")").replace("xxx3xxx", ",");
    }

    private Set<Map<Integer, Set<FolAtom>>> parseLpT(String[] lines, ActionSignature signature) {
        HashSet<Map<Integer, Set<FolAtom>>> result = new HashSet<Map<Integer, Set<FolAtom>>>();
        for (String line : lines) {
            result.add(this.parseLpTSingleLine(line, signature));
        }
        return result;
    }

    private Map<Integer, Set<FolAtom>> parseLpTSingleLine(String s, ActionSignature signature) throws ParserException {
        String[] tokens;
        HashMap<Integer, Set<FolAtom>> map = new HashMap<Integer, Set<FolAtom>>();
        for (String token : tokens = s.split(" ")) {
            int i = Integer.parseInt((token = token.trim()).substring(token.indexOf("(") + 1, token.indexOf(")")));
            if (map.get(i) == null) {
                map.put(i, new HashSet());
            }
            if (token.startsWith("-")) continue;
            FolParser p = new FolParser();
            p.setSignature((FolSignature)signature);
            FolAtom a = null;
            try {
                a = (FolAtom)p.parseFormula(this.regainIllegalChars(token.substring(0, token.indexOf("("))));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ((Set)map.get(i)).add(a);
        }
        return map;
    }

    private String getRuleBodyString(FolFormula f, int t, boolean negated) {
        Object result = "";
        if (f instanceof Conjunction) {
            Conjunction c = (Conjunction)f;
            for (RelationalFormula literal : c) {
                if (!((String)result).equals("")) {
                    result = (String)result + ",";
                }
                result = (String)result + this.getLiteralString((FolFormula)literal, t, negated);
            }
        } else {
            result = this.getLiteralString(f, t, negated);
        }
        return result;
    }

    private String getLiteralString(FolFormula f, int t, boolean negated) {
        Object result;
        Object object = result = negated ? "not " : "";
        if (f instanceof Negation) {
            result = (String)result + (negated ? "" : "-");
            result = (String)result + this.getAtomString((RelationalFormula)((Negation)f).getFormula(), t);
        } else if (f instanceof FolAtom) {
            result = (String)result + (negated ? "-" : "");
            result = (String)result + this.getAtomString((RelationalFormula)f, t);
        } else if (f instanceof Tautology) {
            result = "";
        } else if (f instanceof Contradiction) {
            result = "";
        } else {
            throw new IllegalArgumentException("Not a valid Literal.");
        }
        return result;
    }

    private String getAtomString(RelationalFormula f, int t) {
        if (!(f instanceof FolAtom)) {
            throw new IllegalArgumentException("Cannot calculate transition system. Causal rule is not definite.");
        }
        return this.removeIllegalChars(f.toString()) + "(" + Integer.toString(t) + ")";
    }
}

