/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.description.syntax;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.tweety.action.description.syntax.ActionDescription;
import net.sf.tweety.action.description.syntax.CLaw;
import net.sf.tweety.action.description.syntax.CausalLaw;
import net.sf.tweety.action.description.syntax.DynamicLaw;
import net.sf.tweety.action.description.syntax.StaticLaw;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.commons.Signature;

public class CActionDescription
extends ActionDescription<CLaw> {
    public CActionDescription() {
    }

    public CActionDescription(Collection<? extends CausalLaw> c) {
        for (CausalLaw causalLaw : c) {
            if (causalLaw instanceof CLaw) {
                this.add((CLaw)causalLaw);
                continue;
            }
            throw new IllegalArgumentException("The action description given contains laws of a wrong type.");
        }
    }

    public CActionDescription ground() {
        HashSet<CLaw> laws = new HashSet<CLaw>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CLaw law = (CLaw)iterator.next();
            laws.addAll(law.getAllGrounded());
        }
        return new CActionDescription((Collection<? extends CausalLaw>)laws);
    }

    public CActionDescription toDefinite() throws IllegalStateException {
        HashSet<CLaw> laws = new HashSet<CLaw>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CLaw law = (CLaw)iterator.next();
            laws.addAll(law.toDefinite());
        }
        return new CActionDescription((Collection<? extends CausalLaw>)laws);
    }

    public boolean isGround() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CLaw law = (CLaw)iterator.next();
            if (law.isGround()) continue;
            return false;
        }
        return true;
    }

    public boolean isDefinite() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CLaw law = (CLaw)iterator.next();
            if (law.isDefinite()) continue;
            return false;
        }
        return true;
    }

    public Set<StaticLaw> getStaticLaws() {
        HashSet<StaticLaw> result = new HashSet<StaticLaw>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CLaw r = (CLaw)iterator.next();
            if (!(r instanceof StaticLaw)) continue;
            result.add((StaticLaw)r);
        }
        return result;
    }

    public Set<DynamicLaw> getDynamicLaws() {
        HashSet<DynamicLaw> result = new HashSet<DynamicLaw>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CLaw r = (CLaw)iterator.next();
            if (!(r instanceof DynamicLaw)) continue;
            result.add((DynamicLaw)r);
        }
        return result;
    }

    public String toOutputString() {
        Object result = ":- laws\n";
        for (CLaw cLaw : this.getStaticLaws()) {
            result = (String)result + cLaw.toString() + "\n";
        }
        for (CLaw cLaw : this.getDynamicLaws()) {
            result = (String)result + cLaw.toString() + "\n";
        }
        return result;
    }

    public Signature getMinimalSignature() {
        ActionSignature sig = new ActionSignature();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CLaw r = (CLaw)iterator.next();
            sig.addAll(r.getFormulas());
        }
        return sig;
    }
}

