/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.description.syntax;

import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.action.description.syntax.CausalLaw;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.action.signature.FolFluentName;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.logics.commons.syntax.RelationalFormula;
import net.sf.tweety.logics.fol.syntax.Conjunction;
import net.sf.tweety.logics.fol.syntax.Contradiction;
import net.sf.tweety.logics.fol.syntax.Disjunction;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.Negation;
import net.sf.tweety.logics.fol.syntax.Tautology;

public abstract class CLaw
implements CausalLaw {
    protected FolFormula headFormula = new Contradiction();
    protected FolFormula ifFormula = new Tautology();
    protected Set<GroundingRequirement> requirements = new HashSet<GroundingRequirement>();

    public abstract Signature getSignature();

    public abstract boolean isDefinite();

    public abstract Set<CLaw> toDefinite() throws IllegalStateException;

    public abstract Set<FolAtom> getAtoms();

    public abstract Set<FolFormula> getFormulas();

    public CLaw() {
    }

    public CLaw(FolFormula headFormula) {
        this.setHeadFormula(headFormula);
    }

    public CLaw(FolFormula headFormula, Set<GroundingRequirement> requirements) {
        this.setHeadFormula(headFormula);
        this.setGroundingRequirements(requirements);
    }

    public CLaw(FolFormula headFormula, FolFormula ifFormula, Set<GroundingRequirement> requirements) {
        this.setHeadFormula(headFormula);
        this.setIfFormula(ifFormula);
        this.setGroundingRequirements(requirements);
    }

    public CLaw(FolFormula headFormula, FolFormula ifFormula) {
        this.setHeadFormula(headFormula);
        this.setIfFormula(ifFormula);
    }

    private void setGroundingRequirements(Set<GroundingRequirement> requirements) {
        if (requirements != null) {
            this.requirements.addAll(requirements);
        }
    }

    private void setHeadFormula(FolFormula headFormula) {
        if (headFormula == null) {
            this.headFormula = new Contradiction();
            return;
        }
        if (!new ActionSignature(headFormula).isRepresentable(headFormula)) {
            throw new IllegalArgumentException("The formula given has an illegal form");
        }
        this.headFormula = (FolFormula)headFormula.collapseAssociativeFormulas();
    }

    private void setIfFormula(FolFormula ifFormula) {
        if (ifFormula == null) {
            this.ifFormula = new Tautology();
            return;
        }
        if (!new ActionSignature(ifFormula).isRepresentable(ifFormula)) {
            throw new IllegalArgumentException("The formula given has an illegal form");
        }
        this.ifFormula = (FolFormula)ifFormula.collapseAssociativeFormulas();
    }

    public void addGroundingRequirement(GroundingRequirement c) {
        this.requirements.add(c);
    }

    public FolFormula getHeadFormula() {
        return this.headFormula;
    }

    public FolFormula getIfFormula() {
        return this.ifFormula;
    }

    public boolean isGround() {
        for (FolAtom a : this.getAtoms()) {
            if (a.isGround()) continue;
            return false;
        }
        return true;
    }

    public abstract Set<CLaw> getAllGrounded();

    protected boolean isValidDefiniteHead(RelationalFormula pl) {
        if (pl instanceof Contradiction) {
            return true;
        }
        if (pl instanceof Negation) {
            pl = ((Negation)pl).getFormula();
        }
        if (pl instanceof FolAtom) {
            return ((FolAtom)pl).getPredicate() instanceof FolFluentName;
        }
        return false;
    }

    protected boolean isConjunctiveClause(FolFormula pl) {
        if (pl instanceof Conjunction) {
            for (RelationalFormula p : (Conjunction)pl) {
                if (((FolFormula)p).isLiteral()) continue;
                return false;
            }
        } else if (pl instanceof Disjunction) {
            return false;
        }
        return true;
    }
}

