/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.description.syntax;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.description.syntax.CLaw;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.action.grounding.GroundingTools;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.RelationalFormula;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.fol.syntax.Disjunction;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.Tautology;

public class DynamicLaw
extends CLaw {
    protected FolFormula afterFormula = new Tautology();

    public DynamicLaw() {
    }

    public DynamicLaw(FolFormula headFormula, FolFormula ifFormula, FolFormula afterFormula) {
        super(headFormula, ifFormula);
        this.setAfterFormula(afterFormula);
    }

    public DynamicLaw(FolFormula headFormula, FolFormula ifFormula, FolFormula afterFormula, Set<GroundingRequirement> requirements) {
        super(headFormula, ifFormula, requirements);
        this.setAfterFormula(afterFormula);
    }

    public DynamicLaw(FolFormula headFormula, FolFormula afterFormula) {
        super(headFormula);
        this.setAfterFormula(afterFormula);
    }

    public DynamicLaw(FolFormula headFormula, FolFormula afterFormula, Set<GroundingRequirement> requirements) {
        super(headFormula, requirements);
        this.setAfterFormula(afterFormula);
    }

    private void setAfterFormula(FolFormula afterFormula) {
        if (afterFormula == null) {
            return;
        }
        if (!new ActionSignature(afterFormula).isRepresentable(afterFormula)) {
            throw new IllegalArgumentException("The formula given has an illegal form");
        }
        this.afterFormula = (FolFormula)afterFormula.collapseAssociativeFormulas();
    }

    public FolFormula getAfterFormula() {
        return this.afterFormula;
    }

    @Override
    public boolean isDefinite() {
        if (!this.headFormula.isLiteral()) {
            return false;
        }
        if (!this.isConjunctiveClause(this.ifFormula)) {
            return false;
        }
        return this.isConjunctiveClause(this.afterFormula);
    }

    public String toString() {
        if (this.ifFormula.equals(this.headFormula) && this.ifFormula.equals(this.afterFormula)) {
            return "inertial " + this.headFormula.toString();
        }
        String r = "caused " + this.headFormula.toString();
        if (!(this.ifFormula instanceof Tautology)) {
            r = r + " if " + this.ifFormula.toString();
        }
        r = r + " after " + this.afterFormula.toString();
        return r;
    }

    @Override
    public Signature getSignature() {
        ActionSignature sig = new ActionSignature(this.headFormula);
        sig.add(this.ifFormula);
        sig.add(this.afterFormula);
        return sig;
    }

    @Override
    public Set<FolAtom> getAtoms() {
        HashSet<FolAtom> result = new HashSet<FolAtom>();
        result.addAll(this.headFormula.getAtoms());
        result.addAll(this.ifFormula.getAtoms());
        result.addAll(this.afterFormula.getAtoms());
        return result;
    }

    @Override
    public Set<CLaw> toDefinite() {
        if (!this.isValidDefiniteHead((RelationalFormula)this.headFormula)) {
            throw new IllegalStateException("Cannot convert causal law with nonliteral head formula to definite form.");
        }
        HashSet<CLaw> definit = new HashSet<CLaw>();
        HashSet<Object> ifClauses = new HashSet<Object>();
        HashSet<Object> afterClauses = new HashSet<Object>();
        FolFormula ifDNF = this.ifFormula.toDnf();
        if (ifDNF instanceof Disjunction) {
            Disjunction conjClause = (Disjunction)ifDNF;
            for (RelationalFormula relationalFormula : conjClause) {
                ifClauses.add(relationalFormula);
            }
        } else {
            ifClauses.add(ifDNF);
        }
        FolFormula afterDNF = (FolFormula)this.afterFormula.toDnf().collapseAssociativeFormulas();
        if (afterDNF instanceof Disjunction) {
            Disjunction conjClause = (Disjunction)afterDNF;
            for (RelationalFormula p : conjClause) {
                afterClauses.add(p);
            }
        } else {
            afterClauses.add(afterDNF);
        }
        for (RelationalFormula relationalFormula : ifClauses) {
            for (RelationalFormula relationalFormula2 : afterClauses) {
                definit.add(new DynamicLaw(this.headFormula, (FolFormula)relationalFormula, (FolFormula)relationalFormula2, this.requirements));
            }
        }
        return definit;
    }

    @Override
    public Set<CLaw> getAllGrounded() {
        HashSet<CLaw> result = new HashSet<CLaw>();
        HashSet<Variable> variables = new HashSet<Variable>();
        for (FolAtom a : this.getAtoms()) {
            variables.addAll(a.getUnboundVariables());
        }
        Set<Map<Variable, Constant>> substitutions = GroundingTools.getAllSubstitutions(variables);
        for (Map<Variable, Constant> map : substitutions) {
            if (!GroundingTools.isValidGroundingApplication(map, this.requirements)) continue;
            result.add(new DynamicLaw((FolFormula)this.headFormula.substitute(map), (FolFormula)this.ifFormula.substitute(map), (FolFormula)this.afterFormula.substitute(map), this.requirements));
        }
        return result;
    }

    @Override
    public Set<FolFormula> getFormulas() {
        HashSet<FolFormula> result = new HashSet<FolFormula>();
        result.add(this.headFormula);
        result.add(this.ifFormula);
        result.add(this.afterFormula);
        return result;
    }
}

