/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.description.syntax;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.description.syntax.CLaw;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.action.grounding.GroundingTools;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.RelationalFormula;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.fol.syntax.Disjunction;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.Tautology;

public class StaticLaw
extends CLaw {
    public StaticLaw() {
    }

    public StaticLaw(FolFormula headFormula) {
        super(headFormula);
    }

    public StaticLaw(FolFormula headFormula, Set<GroundingRequirement> requirements) {
        super(headFormula, requirements);
    }

    public StaticLaw(FolFormula headFormula, FolFormula ifFormula) {
        super(headFormula, ifFormula);
    }

    public StaticLaw(FolFormula headFormula, FolFormula ifFormula, Set<GroundingRequirement> requirements) {
        super(headFormula, ifFormula, requirements);
    }

    @Override
    public boolean isDefinite() {
        return this.isValidDefiniteHead((RelationalFormula)this.headFormula) && this.isConjunctiveClause(this.ifFormula);
    }

    public String toString() {
        String r = "caused " + this.headFormula.toString();
        if (!(this.ifFormula instanceof Tautology)) {
            r = r + " if " + this.ifFormula.toString();
        }
        return r;
    }

    @Override
    public Set<CLaw> toDefinite() throws IllegalStateException {
        HashSet<CLaw> result = new HashSet<CLaw>();
        if (!this.isValidDefiniteHead((RelationalFormula)this.headFormula)) {
            throw new IllegalStateException("Cannot convert causal law with nonliteral head formula to definite form.");
        }
        FolFormula ifForm = this.ifFormula.toDnf();
        if (ifForm instanceof Disjunction) {
            Disjunction conjClause = (Disjunction)ifForm;
            for (RelationalFormula p : conjClause) {
                result.add(new StaticLaw(this.headFormula, (FolFormula)p, this.requirements));
            }
        } else {
            result.add(new StaticLaw(this.headFormula, ifForm, this.requirements));
        }
        return result;
    }

    @Override
    public Signature getSignature() {
        ActionSignature sig = new ActionSignature(this.headFormula);
        sig.add(this.ifFormula);
        return sig;
    }

    @Override
    public Set<FolAtom> getAtoms() {
        HashSet<FolAtom> atoms = new HashSet<FolAtom>();
        atoms.addAll(this.headFormula.getAtoms());
        atoms.addAll(this.ifFormula.getAtoms());
        return atoms;
    }

    @Override
    public Set<CLaw> getAllGrounded() {
        HashSet<CLaw> result = new HashSet<CLaw>();
        HashSet<Variable> variables = new HashSet<Variable>();
        for (FolAtom a : this.getAtoms()) {
            variables.addAll(a.getUnboundVariables());
        }
        Set<Map<Variable, Constant>> substitutions = GroundingTools.getAllSubstitutions(variables);
        for (Map<Variable, Constant> map : substitutions) {
            if (!GroundingTools.isValidGroundingApplication(map, this.requirements)) continue;
            result.add(new StaticLaw((FolFormula)this.headFormula.substitute(map), (FolFormula)this.ifFormula.substitute(map), this.requirements));
        }
        return result;
    }

    @Override
    public Set<FolFormula> getFormulas() {
        HashSet<FolFormula> result = new HashSet<FolFormula>();
        result.add(this.headFormula);
        result.add(this.ifFormula);
        return result;
    }
}

