/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.grounding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.commons.util.MapTools;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Sort;
import net.sf.tweety.logics.commons.syntax.Variable;

public class GroundingTools {
    public static boolean isValidGroundingApplication(Map<Variable, Constant> map, Set<GroundingRequirement> requirements) {
        for (GroundingRequirement req : requirements) {
            if (req.isValid(map)) continue;
            return false;
        }
        return true;
    }

    public static Set<Map<Variable, Constant>> getAllSubstitutions(Set<Variable> variables, Set<Constant> constants) {
        HashMap sorts_variables = new HashMap();
        for (Variable variable : variables) {
            if (!sorts_variables.containsKey(variable.getSort())) {
                sorts_variables.put(variable.getSort(), new HashSet());
            }
            ((Set)sorts_variables.get(variable.getSort())).add(variable);
        }
        HashMap sorts_consts = new HashMap();
        for (Constant c : constants) {
            if (!sorts_consts.containsKey(c.getSort())) {
                sorts_consts.put(c.getSort(), new HashSet());
            }
            ((Set)sorts_consts.get(c.getSort())).add(c);
        }
        HashMap<Set, Set> hashMap = new HashMap<Set, Set>();
        for (Sort s : sorts_variables.keySet()) {
            if (!sorts_consts.containsKey(s)) {
                throw new IllegalArgumentException("There is no constant of sort " + s + " to substitute.");
            }
            hashMap.put((Set)sorts_variables.get(s), (Set)sorts_consts.get(s));
        }
        return new MapTools().allMaps(hashMap);
    }

    public static Set<Map<Variable, Constant>> getAllSubstitutions(Set<Variable> variables) {
        HashMap sorts_variables = new HashMap();
        for (Variable v : variables) {
            if (!sorts_variables.containsKey(v.getSort())) {
                sorts_variables.put(v.getSort(), new HashSet());
            }
            ((Set)sorts_variables.get(v.getSort())).add(v);
        }
        HashMap<Set, Set> relations = new HashMap<Set, Set>();
        for (Sort s : sorts_variables.keySet()) {
            if (s.getTerms(Constant.class).isEmpty()) continue;
            relations.put((Set)sorts_variables.get(s), s.getTerms(Constant.class));
        }
        return new MapTools().allMaps(relations);
    }
}

