/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.grounding.parser;

import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.action.grounding.VarConstNeqRequirement;
import net.sf.tweety.action.grounding.VarsNeqRequirement;
import net.sf.tweety.commons.ParserException;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Sort;
import net.sf.tweety.logics.commons.syntax.Variable;

public class GroundingRequirementsParser {
    public Set<GroundingRequirement> parseRequirements(String s, Set<Variable> variables) throws ParserException {
        String[] reqs;
        HashSet<GroundingRequirement> result = new HashSet<GroundingRequirement>();
        if (s == null || s.trim().equals("")) {
            return result;
        }
        for (String token : reqs = s.split(",")) {
            token = token.trim();
            result.add(this.parseRequirement(s, variables));
        }
        return result;
    }

    public GroundingRequirement parseRequirement(String s, Set<Variable> variables) throws ParserException {
        Constant constant;
        String[] params = s.split("<>");
        if (params.length != 2) {
            throw new ParserException("Missing '<>' in grounding requirement.");
        }
        String par1 = params[0].trim();
        String par2 = params[1].trim();
        Variable var1 = null;
        Variable var2 = null;
        for (Variable v : variables) {
            if (v.get().equals(par1)) {
                var1 = v;
                continue;
            }
            if (!v.get().equals(par2)) continue;
            var2 = v;
        }
        if (var1 == null && var2 == null) {
            throw new ParserException("Missing variable in grounding requirement.");
        }
        if (var1 == null) {
            constant = this.getConstant(par1, var2.getSort());
            if (constant == null) {
                throw new ParserException("Element '" + par1 + "' in grounding requirement has to be a constant of sort '" + var2.getSort().toString() + "'.");
            }
            return new VarConstNeqRequirement(var2, constant);
        }
        if (var2 == null) {
            constant = this.getConstant(par2, var1.getSort());
            if (constant == null) {
                throw new ParserException("Element '" + par2 + "' in grounding requirement has to be a constant of sort '" + var1.getSort().toString() + "'.");
            }
            return new VarConstNeqRequirement(var1, constant);
        }
        return new VarsNeqRequirement(var1, var2);
    }

    private Constant getConstant(String name, Sort sort) {
        for (Constant c : sort.getTerms(Constant.class)) {
            if (c.get() != name) continue;
            return c;
        }
        return null;
    }
}

