/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.query.analysis;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.tweety.action.query.analysis.ActionQuerySatisfactionTester;
import net.sf.tweety.action.query.syntax.ActionQuery;
import net.sf.tweety.action.query.syntax.AlwaysQuery;
import net.sf.tweety.action.query.syntax.HoldsQuery;
import net.sf.tweety.action.query.syntax.NecessarilyQuery;
import net.sf.tweety.action.query.syntax.QueryProposition;
import net.sf.tweety.action.query.syntax.SActionQuery;
import net.sf.tweety.action.query.syntax.SActionQuerySet;
import net.sf.tweety.action.signature.FolAction;
import net.sf.tweety.action.transitionsystem.State;
import net.sf.tweety.action.transitionsystem.Transition;
import net.sf.tweety.action.transitionsystem.TransitionSystem;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.logics.commons.syntax.RelationalFormula;
import net.sf.tweety.logics.fol.syntax.AssociativeFolFormula;
import net.sf.tweety.logics.fol.syntax.Contradiction;
import net.sf.tweety.logics.fol.syntax.Disjunction;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.Negation;
import net.sf.tweety.logics.pl.syntax.AssociativePlFormula;
import net.sf.tweety.logics.pl.syntax.Conjunction;
import net.sf.tweety.logics.pl.syntax.PlFormula;
import net.sf.tweety.logics.pl.syntax.Proposition;
import net.sf.tweety.lp.asp.reasoner.ASPSolver;

public class SActionQuerySatisfactionTester
implements ActionQuerySatisfactionTester {
    public SActionQuerySatisfactionTester(ASPSolver aspsolver) {
    }

    @Override
    public boolean isSatisfied(TransitionSystem transitionSystem, BeliefBase actionQueries) {
        if (transitionSystem == null) {
            return false;
        }
        Object program = "";
        program = (String)program + this.getTransitionSystemRules(transitionSystem);
        SActionQuerySet qset = (SActionQuerySet)actionQueries;
        program = (String)program + this.getRules((Collection<SActionQuery>)((Object)qset));
        program = (String)program + this.getConstraints((Collection<? extends SActionQuery>)((Object)qset));
        boolean result = false;
        System.out.println((String)program);
        return result;
    }

    @Override
    public boolean isSatisfied(TransitionSystem transitionSystem, Set<ActionQuery> actionQueries) {
        SActionQuerySet qset = new SActionQuerySet();
        for (ActionQuery q : actionQueries) {
            if (!(q instanceof SActionQuery)) {
                return false;
            }
            qset.add((SActionQuery)q);
        }
        return this.isSatisfied(transitionSystem, (BeliefBase)qset);
    }

    private String getConstraints(Collection<? extends SActionQuery> queries) {
        Object result = "";
        for (SActionQuery sActionQuery : queries) {
            result = (String)result + ":- not ";
            result = (String)result + this.removeIllegalCharacters(sActionQuery.toString());
            result = (String)result + "(S), state(S).\n";
        }
        return result;
    }

    private String getRules(Collection<SActionQuery> queries) {
        HashSet<FolFormula> stateParts = new HashSet<FolFormula>();
        HashSet<PlFormula> queryParts = new HashSet<PlFormula>();
        HashSet<QueryProposition> queryPropositions = new HashSet<QueryProposition>();
        for (SActionQuery q : queries) {
            queryPropositions.addAll(this.getQueryPropositions(q));
            queryParts.addAll(this.getQueryParts(q.getFormula()));
        }
        for (QueryProposition queryProposition : queryPropositions) {
            stateParts.addAll(this.getStateParts(queryProposition.getInnerFormula()));
        }
        Object result = "";
        for (FolFormula f : stateParts) {
            result = (String)result + this.getStatePartRules(f);
        }
        for (PlFormula p : queryParts) {
            result = (String)result + this.getQueryPartRules(p);
        }
        for (QueryProposition q : queryPropositions) {
            result = (String)result + this.getQueryPropositionPartRules(q);
        }
        return result;
    }

    private String getStatePartRules(FolFormula statePart) {
        Object result = "";
        if (statePart instanceof Negation) {
            Negation neg = (Negation)statePart;
            result = (String)result + this.removeIllegalCharacters(neg.toString());
            result = (String)result + "(S) :- not ";
            result = (String)result + this.removeIllegalCharacters(neg.getFormula().toString());
            result = (String)result + "(S), state(S).\n";
        } else if (statePart instanceof net.sf.tweety.logics.fol.syntax.Conjunction) {
            net.sf.tweety.logics.fol.syntax.Conjunction conj = (net.sf.tweety.logics.fol.syntax.Conjunction)statePart;
            result = (String)result + this.removeIllegalCharacters(conj.toString());
            result = (String)result + "(S) :- ";
            for (RelationalFormula f : conj) {
                result = (String)result + this.removeIllegalCharacters(f.toString());
                result = (String)result + "(S), ";
            }
            result = (String)result + "state(S).\n";
        } else if (statePart instanceof Disjunction) {
            Disjunction disj = (Disjunction)statePart;
            for (RelationalFormula f : disj) {
                result = (String)result + this.removeIllegalCharacters(disj.toString());
                result = (String)result + "(S) :- ";
                result = (String)result + this.removeIllegalCharacters(f.toString());
                result = (String)result + "(S), state(S).\n";
            }
        }
        return result;
    }

    private String getQueryPartRules(PlFormula queryPart) {
        Object result = "";
        if (queryPart instanceof net.sf.tweety.logics.pl.syntax.Negation) {
            net.sf.tweety.logics.pl.syntax.Negation neg = (net.sf.tweety.logics.pl.syntax.Negation)queryPart;
            result = (String)result + this.removeIllegalCharacters(neg.toString());
            result = (String)result + "(S) :- not ";
            result = (String)result + this.removeIllegalCharacters(neg.getFormula().toString());
            result = (String)result + "(S), state(S).\n";
        } else if (queryPart instanceof Conjunction) {
            Conjunction conj = (Conjunction)queryPart;
            result = (String)result + this.removeIllegalCharacters(conj.toString());
            result = (String)result + "(S) :- ";
            for (PlFormula f : conj) {
                result = (String)result + this.removeIllegalCharacters(f.toString());
                result = (String)result + "(S), ";
            }
            result = (String)result + "state(S).\n";
        } else if (queryPart instanceof net.sf.tweety.logics.pl.syntax.Disjunction) {
            net.sf.tweety.logics.pl.syntax.Disjunction disj = (net.sf.tweety.logics.pl.syntax.Disjunction)queryPart;
            for (PlFormula p : disj) {
                result = (String)result + this.removeIllegalCharacters(disj.toString());
                result = (String)result + "(S) :- ";
                result = (String)result + this.removeIllegalCharacters(p.toString());
                result = (String)result + "(S), state(S).\n";
            }
        }
        return result;
    }

    private String getQueryPropositionPartRules(QueryProposition queryProposition) {
        Object result = "";
        if (queryProposition instanceof HoldsQuery) {
            HoldsQuery holdsQuery = (HoldsQuery)queryProposition;
            result = (String)result + this.removeIllegalCharacters(holdsQuery.toString());
            result = (String)result + "(S) :- ";
            result = (String)result + this.removeIllegalCharacters(holdsQuery.getInnerFormula().toString());
            result = (String)result + "(S), state(S).\n";
        } else if (queryProposition instanceof AlwaysQuery) {
            AlwaysQuery alwaysQuery = (AlwaysQuery)queryProposition;
            result = (String)result + this.removeIllegalCharacters(alwaysQuery.toString());
            result = (String)result + "(S) :- not ";
            result = (String)result + this.removeIllegalCharacters(alwaysQuery.getInnerFormula().toString());
            result = (String)result + "_notalways, state(S).\n";
            result = (String)result + this.removeIllegalCharacters(alwaysQuery.getInnerFormula().toString());
            result = (String)result + "_notalways :- not ";
            result = (String)result + this.removeIllegalCharacters(alwaysQuery.getInnerFormula().toString());
            result = (String)result + "(S), state(S).\n";
        } else if (queryProposition instanceof NecessarilyQuery) {
            NecessarilyQuery necessarilyQuery = (NecessarilyQuery)queryProposition;
            result = (String)result + this.removeIllegalCharacters(necessarilyQuery.toString());
            result = (String)result + "(S) :- not ";
            result = (String)result + this.removeIllegalCharacters(necessarilyQuery.toString());
            result = (String)result + "_neg(S), state(S).\n";
            result = (String)result + this.removeIllegalCharacters(necessarilyQuery.toString());
            result = (String)result + "_neg(S) :- t(S,";
            result = (String)result + this.removeIllegalCharacters(necessarilyQuery.getActions().get(0).toString());
            result = (String)result + ",S2), state(S), state(S2)";
            if (necessarilyQuery.getActions().size() > 1) {
                result = (String)result + ", not ";
                result = (String)result + this.removeIllegalCharacters(this.getNecessarilyQueryMinusFirstAction(necessarilyQuery).toString());
                result = (String)result + "(S2)";
            } else if (!(necessarilyQuery.getInnerFormula() instanceof Contradiction)) {
                result = (String)result + ", not ";
                result = (String)result + this.removeIllegalCharacters(necessarilyQuery.getInnerFormula().toString());
                result = (String)result + "(S2)";
            }
            result = (String)result + ".\n";
        }
        return result;
    }

    private Set<FolFormula> getStateParts(FolFormula formula) {
        HashSet<FolFormula> result = new HashSet<FolFormula>();
        result.add(formula);
        if (formula instanceof AssociativeFolFormula) {
            for (RelationalFormula rel : (AssociativeFolFormula)formula) {
                result.addAll(this.getStateParts((FolFormula)rel));
            }
        } else if (formula instanceof Negation) {
            Negation neg = (Negation)formula;
            FolFormula f = neg.getFormula();
            result.addAll(this.getStateParts(f));
        }
        return result;
    }

    private Set<PlFormula> getQueryParts(PlFormula formula) {
        HashSet<PlFormula> result = new HashSet<PlFormula>();
        result.add(formula);
        if (formula instanceof AssociativePlFormula) {
            for (PlFormula f : (AssociativePlFormula)formula) {
                result.addAll(this.getQueryParts(f));
            }
        } else if (formula instanceof net.sf.tweety.logics.pl.syntax.Negation) {
            net.sf.tweety.logics.pl.syntax.Negation neg = (net.sf.tweety.logics.pl.syntax.Negation)formula;
            result.addAll(this.getQueryParts(neg.getFormula()));
        }
        return result;
    }

    private Set<QueryProposition> getQueryPropositions(SActionQuery query) {
        HashSet<QueryProposition> result = new HashSet<QueryProposition>();
        for (Proposition p : query.getFormula().getAtoms()) {
            QueryProposition qprop = (QueryProposition)p;
            result.add(qprop);
            if (!(qprop instanceof NecessarilyQuery)) continue;
            NecessarilyQuery nec = (NecessarilyQuery)qprop;
            while (nec.getActions().size() > 1) {
                nec = this.getNecessarilyQueryMinusFirstAction(nec);
                result.add(nec);
            }
        }
        return result;
    }

    private String getTransitionSystemRules(TransitionSystem transitionSystem) {
        Object statefacts = "";
        Object fluentfacts = "";
        Object transitionfacts = "";
        int statecounter = 0;
        HashMap<State, CallSite> statemap = new HashMap<State, CallSite>();
        for (State s : transitionSystem.getStates()) {
            String statename = "s" + Integer.toString(statecounter);
            statemap.put(s, (CallSite)((Object)statename));
            statefacts = (String)statefacts + "state(" + statename + ").\n";
            for (FolAtom a : s.getPositiveFluents()) {
                fluentfacts = (String)fluentfacts + this.removeIllegalCharacters(a.toString());
                fluentfacts = (String)fluentfacts + "(" + statename + ").\n";
            }
            fluentfacts = (String)fluentfacts + "\n";
            ++statecounter;
        }
        for (Transition t : transitionSystem.getTransitions()) {
            transitionfacts = (String)transitionfacts + "t(" + (String)statemap.get(t.getFrom()) + "," + this.removeIllegalCharacters(t.getAction().toString()) + "," + (String)statemap.get(t.getTo()) + ").\n";
        }
        return (String)statefacts + "\n" + (String)fluentfacts + "\n" + (String)transitionfacts;
    }

    private NecessarilyQuery getNecessarilyQueryMinusFirstAction(NecessarilyQuery q) {
        List<FolAction> actionList = q.getActions();
        if (actionList.size() < 2) {
            return q;
        }
        actionList.remove(0);
        return new NecessarilyQuery(q.getInnerFormula(), actionList);
    }

    private String removeIllegalCharacters(String s) {
        return s.replace("(", "xxx1xxx").replace(")", "xxx2xxx").replace(",", "xxx3xxx").replace("!", "xxx4xxx").replace("&&", "xxx5xxx").replace("||", "xxx6xxx").replace("[", "xxx7xxx").replace("]", "xxx8xxx").replace("{", "xxx9xxx").replace("}", "xxx10xxx").replace(" ", "xxx11xxx").replace("+", "xxx12xxx").replace("-", "xxx13xxx").replace(";", "xxx14xxx");
    }

    public String regainIllegalCharacters(String s) {
        return s.replace("xxx1xxx", "(").replace("xxx2xxx", ")").replace("xxx3xxx", ",").replace("xxx4xxx", "!").replace("xxx5xxx", "&&").replace("xxx6xxx", "||").replace("xxx7xxx", "[").replace("xxx8xxx", "]").replace("xxx9xxx", "{").replace("xxx10xxx", "}").replace("xxx11xxx", " ").replace("xxx12xxx", "+").replace("xxx13xxx", "-").replace("xxx14xxx", ";");
    }
}

