/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.query.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.action.grounding.parser.GroundingRequirementsParser;
import net.sf.tweety.action.query.syntax.AlwaysQuery;
import net.sf.tweety.action.query.syntax.HoldsQuery;
import net.sf.tweety.action.query.syntax.NecessarilyQuery;
import net.sf.tweety.action.query.syntax.QueryProposition;
import net.sf.tweety.action.query.syntax.SActionQuery;
import net.sf.tweety.action.query.syntax.SActionQuerySet;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.action.signature.FolAction;
import net.sf.tweety.action.signature.FolActionName;
import net.sf.tweety.commons.Parser;
import net.sf.tweety.commons.ParserException;
import net.sf.tweety.logics.commons.LogicalSymbols;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.fol.parser.FolParser;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.FolSignature;
import net.sf.tweety.logics.pl.syntax.Conjunction;
import net.sf.tweety.logics.pl.syntax.Contradiction;
import net.sf.tweety.logics.pl.syntax.Disjunction;
import net.sf.tweety.logics.pl.syntax.Negation;
import net.sf.tweety.logics.pl.syntax.PlFormula;
import net.sf.tweety.logics.pl.syntax.Proposition;
import net.sf.tweety.logics.pl.syntax.Tautology;

public class ActionQueryParser
extends Parser<SActionQuerySet, SActionQuery> {
    private ActionSignature signature;

    public ActionQueryParser(ActionSignature signature) {
        this.signature = signature;
    }

    public SActionQuerySet parseBeliefBase(Reader reader) {
        SActionQuerySet beliefSet = new SActionQuerySet();
        Object s = "";
        try {
            int c = reader.read();
            while (c != -1) {
                if (c == 10) {
                    if (!((String)s).equals("") && !((String)s).trim().startsWith("%")) {
                        beliefSet.add(this.parseFormula(new StringReader((String)s)));
                    }
                    s = "";
                } else {
                    s = (String)s + (char)c;
                }
                c = reader.read();
            }
            if (!((String)s).equals("") && !((String)s).trim().startsWith("%")) {
                beliefSet.add(this.parseFormula(new StringReader((String)s)));
            }
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
        return beliefSet;
    }

    public SActionQuery parseFormula(Reader reader) throws IOException, ParserException {
        Stack<Object> stack = new Stack<Object>();
        try {
            int c = reader.read();
            while (c != -1) {
                this.consumeToken(stack, c);
                c = reader.read();
            }
            return this.parseActionFormula(stack);
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    private void consumeToken(Stack<Object> stack, int c) throws ParserException {
        try {
            String s = Character.toString((char)c);
            if (!s.equals(" ")) {
                if (stack.size() >= 4 && stack.get(stack.size() - 4).equals("h") && stack.get(stack.size() - 3).equals("o") && stack.get(stack.size() - 2).equals("l") && stack.get(stack.size() - 1).equals("d") && s.equals("s")) {
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.push("holds");
                } else if (stack.size() >= 4 && stack.get(stack.size() - 4).equals("a") && stack.get(stack.size() - 3).equals("f") && stack.get(stack.size() - 2).equals("t") && stack.get(stack.size() - 1).equals("e") && s.equals("r")) {
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.push("after");
                } else if (stack.size() >= 5 && stack.get(stack.size() - 5).equals("a") && stack.get(stack.size() - 4).equals("l") && stack.get(stack.size() - 3).equals("w") && stack.get(stack.size() - 2).equals("a") && stack.get(stack.size() - 1).equals("y") && s.equals("s")) {
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.push("always");
                } else if (stack.size() >= 7 && stack.get(stack.size() - 7).equals("r") && stack.get(stack.size() - 6).equals("e") && stack.get(stack.size() - 5).equals("q") && stack.get(stack.size() - 4).equals("u") && stack.get(stack.size() - 3).equals("i") && stack.get(stack.size() - 2).equals("r") && stack.get(stack.size() - 1).equals("e") && s.equals("s")) {
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.push("requires");
                } else if (stack.size() >= 10 && stack.get(stack.size() - 10).equals("n") && stack.get(stack.size() - 9).equals("e") && stack.get(stack.size() - 8).equals("c") && stack.get(stack.size() - 7).equals("e") && stack.get(stack.size() - 6).equals("s") && stack.get(stack.size() - 5).equals("s") && stack.get(stack.size() - 4).equals("a") && stack.get(stack.size() - 3).equals("r") && stack.get(stack.size() - 2).equals("i") && stack.get(stack.size() - 1).equals("l") && s.equals("y")) {
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.pop();
                    stack.push("necessarily");
                } else if (stack.contains("[")) {
                    if (s.equals("[")) {
                        throw new ParserException("Unexpected '[' parentheses");
                    }
                    if (s.equals("]")) {
                        Object stateFormula = "";
                        Object o = stack.pop();
                        while (!(o instanceof String) || !((String)o).equals("[")) {
                            stateFormula = (String)o + (String)stateFormula;
                            o = stack.pop();
                        }
                        FolParser p = new FolParser();
                        p.setSignature((FolSignature)this.signature);
                        stack.push(p.parseFormula((String)stateFormula));
                    } else {
                        stack.push(s);
                    }
                } else {
                    if (s.equals("]")) {
                        throw new ParserException("Missing opening parenthesis '['.");
                    }
                    if (stack.contains("{")) {
                        if (s.equals("}")) {
                            ArrayList<Object> l = new ArrayList<Object>();
                            Object o = stack.pop();
                            while (!(o instanceof String) || !((String)o).equals("{")) {
                                l.add(0, o);
                                o = stack.pop();
                            }
                            stack.push(this.parseAction(l));
                        } else {
                            stack.push(s);
                        }
                    } else {
                        if (s.equals("}")) {
                            throw new ParserException("Missing opening parenthesis '{'.");
                        }
                        if (!s.equals(";") && !s.equals(",")) {
                            if (s.equals(")")) {
                                if (!stack.contains("(")) {
                                    throw new ParserException("Missing opening parentheses.");
                                }
                                ArrayList<Object> l = new ArrayList<Object>();
                                Object o = stack.pop();
                                while (!(o instanceof String) || !((String)o).equals("(")) {
                                    l.add(0, o);
                                    o = stack.pop();
                                }
                                stack.push(this.parseDisjunction(l));
                            } else if (s.equals("|")) {
                                if (stack.lastElement().equals("|")) {
                                    stack.pop();
                                    stack.push("||");
                                } else {
                                    stack.push(s);
                                }
                            } else if (s.equals("&")) {
                                if (stack.lastElement().equals("&")) {
                                    stack.pop();
                                    stack.push("&&");
                                } else {
                                    stack.push(s);
                                }
                            } else {
                                stack.push(s);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    private FolAction parseAction(List<Object> l) throws ParserException, IOException {
        if (l.get(0) instanceof String) {
            HashSet<FolAtom> actionNames = new HashSet<FolAtom>();
            Object tmp = "";
            for (Object o : l) {
                if (o instanceof String && ((String)o).equals(",")) {
                    actionNames.add(this.parseActionName((String)tmp));
                    tmp = "";
                    continue;
                }
                tmp = (String)tmp + (String)o;
            }
            actionNames.add(this.parseActionName((String)tmp));
            return new FolAction(actionNames);
        }
        throw new ParserException("Unexpected token in action string.");
    }

    private FolAtom parseActionName(String s) throws ParserException, IOException {
        FolParser p = new FolParser();
        p.setSignature((FolSignature)this.signature);
        FolFormula f = (FolFormula)p.parseFormula(s);
        if (!(f instanceof FolAtom)) {
            throw new ParserException("Illegal type of action name.");
        }
        FolAtom a = (FolAtom)f;
        if (!(a.getPredicate() instanceof FolActionName)) {
            throw new ParserException("Illegal signature of action name.");
        }
        return a;
    }

    private SActionQuery parseActionFormula(Stack<Object> stack) throws ParserException {
        if (stack.isEmpty()) {
            throw new ParserException("Empty action query.");
        }
        if (!stack.contains("requires")) {
            return new SActionQuery(this.parseDisjunction(stack));
        }
        Object requires = "";
        Object o = stack.pop();
        while (!(o instanceof String) || !((String)o).equals("requires")) {
            requires = (String)o + (String)requires;
            o = stack.pop();
        }
        PlFormula disjunction = this.parseDisjunction(stack);
        HashSet<Variable> variables = new HashSet<Variable>();
        for (Proposition p : disjunction.getAtoms()) {
            QueryProposition qp = (QueryProposition)p;
            variables.addAll(qp.getVariables());
        }
        Set<GroundingRequirement> requirements = new GroundingRequirementsParser().parseRequirements((String)requires, variables);
        return new SActionQuery(disjunction, requirements);
    }

    private PlFormula parseDisjunction(List<Object> l) throws ParserException {
        if (l.isEmpty()) {
            throw new ParserException("Empty parentheses.");
        }
        if (!l.contains(LogicalSymbols.DISJUNCTION())) {
            return this.parseConjunction(l);
        }
        Disjunction d = new Disjunction();
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Object o : l) {
            if (o instanceof String && ((String)o).equals(LogicalSymbols.DISJUNCTION())) {
                d.add(this.parseConjunction(tmp));
                tmp = new ArrayList();
                continue;
            }
            tmp.add(o);
        }
        d.add(this.parseConjunction(tmp));
        if (d.size() > 1) {
            return d;
        }
        throw new ParserException("General parsing exception.");
    }

    private PlFormula parseConjunction(List<Object> l) throws ParserException {
        if (l.isEmpty()) {
            throw new ParserException("General parsing exception.");
        }
        if (!l.contains(LogicalSymbols.CONJUNCTION())) {
            return this.parseNegation(l);
        }
        Conjunction c = new Conjunction();
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Object o : l) {
            if (o instanceof String && ((String)o).equals(LogicalSymbols.CONJUNCTION())) {
                c.add(this.parseNegation(tmp));
                tmp = new ArrayList();
                continue;
            }
            tmp.add(o);
        }
        c.add(this.parseNegation(tmp));
        if (c.size() > 1) {
            return c;
        }
        throw new ParserException("General parsing exception.");
    }

    private PlFormula parseNegation(List<Object> l) throws ParserException {
        if (l.get(0).equals(LogicalSymbols.CLASSICAL_NEGATION())) {
            l.remove(0);
            return new Negation(this.parseAtomic(l));
        }
        return this.parseAtomic(l);
    }

    private PlFormula parseAtomic(List<Object> l) throws ParserException {
        if (l.size() == 1) {
            Object o = l.get(0);
            if (o instanceof PlFormula) {
                return (PlFormula)o;
            }
            if (o instanceof String) {
                String s = (String)o;
                if (s.equals(LogicalSymbols.CONTRADICTION())) {
                    return new Contradiction();
                }
                if (s.equals(LogicalSymbols.TAUTOLOGY())) {
                    return new Tautology();
                }
                throw new ParserException("Unknown object: '" + s + "'.");
            }
            throw new ParserException("Unknown object " + o);
        }
        if (l.get(0).equals("holds")) {
            if (l.get(1) instanceof FolFormula) {
                return new HoldsQuery((FolFormula)l.get(1));
            }
            throw new ParserException("Missing inner formula in 'holds' expression.");
        }
        if (l.get(0).equals("always")) {
            if (l.get(1) instanceof FolFormula) {
                return new AlwaysQuery((FolFormula)l.get(1));
            }
            throw new ParserException("Missing inner formula in 'always' expression.");
        }
        if (l.get(0).equals("necessarily")) {
            if (!(l.get(1) instanceof FolFormula)) {
                throw new ParserException("Missing inner formula in 'necessarily' expression.");
            }
            if (l.size() < 4) {
                return new NecessarilyQuery((FolFormula)l.get(1));
            }
            if (!l.get(2).equals("after")) {
                throw new ParserException("Missing 'after' statement in 'necessarily' expression.");
            }
            LinkedList<FolAction> actions = new LinkedList<FolAction>();
            ListIterator<Object> iter = l.listIterator(3);
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof FolAction)) {
                    throw new ParserException("Uexpected element in 'after' part of the 'necessarily' expression: '" + l + "'.");
                }
                actions.add((FolAction)o);
            }
            if (actions.isEmpty()) {
                throw new ParserException("Empty action list in 'necessarily' expression: '" + l + "'.");
            }
            return new NecessarilyQuery((FolFormula)l.get(1), actions);
        }
        throw new ParserException("Could not parse atomic expression: '" + l.toString() + "'.");
    }
}

