/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.query.syntax;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.query.syntax.QueryProposition;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.action.signature.FolAction;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;

public class NecessarilyQuery
extends QueryProposition {
    private List<FolAction> actions = new LinkedList<FolAction>();

    public NecessarilyQuery(FolFormula formula) {
        super(formula, "necessarily " + formula.toString());
        if (!this.getActionSignature().isValidFormula((Formula)formula)) {
            throw new IllegalArgumentException("Invalid inner formula in query proposition.");
        }
    }

    public NecessarilyQuery(FolFormula formula, List<FolAction> actions) {
        super(formula, "necessarily " + formula.toString() + " after " + actions.toString());
        this.actions.addAll(actions);
        if (!this.getActionSignature().isValidFormula((Formula)formula)) {
            throw new IllegalArgumentException("Invalid inner formula in query proposition.");
        }
    }

    public NecessarilyQuery(FolFormula formula, FolAction action) {
        super(formula, "necessarily " + formula.toString() + " after " + action.toString());
        this.actions.add(action);
        if (!this.getActionSignature().isValidFormula((Formula)formula)) {
            throw new IllegalArgumentException("Invalid inner formula in query proposition.");
        }
    }

    public List<FolAction> getActions() {
        LinkedList<FolAction> result = new LinkedList<FolAction>();
        result.addAll(this.actions);
        return result;
    }

    @Override
    public ActionSignature getActionSignature() {
        ActionSignature result = super.getActionSignature();
        for (FolAction a : this.actions) {
            result.addAll(a.getAtoms());
        }
        return result;
    }

    @Override
    public QueryProposition substitute(Map<? extends Term<?>, ? extends Term<?>> map) {
        LinkedList<FolAction> newActions = new LinkedList<FolAction>();
        for (FolAction a : this.actions) {
            newActions.add(a.substitute(map));
        }
        return new NecessarilyQuery((FolFormula)this.formula.substitute(map), newActions);
    }

    @Override
    public Set<FolAction> getInnerActions() {
        return new HashSet<FolAction>(this.actions);
    }

    @Override
    public Set<Variable> getVariables() {
        Set result = this.formula.getUnboundVariables();
        for (FolAction fa : this.actions) {
            for (FolAtom a : fa.getAtoms()) {
                result.addAll(a.getUnboundVariables());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        Object result = "necessarily [";
        result = (String)result + this.formula.toString();
        result = (String)result + "]";
        if (!this.actions.isEmpty()) {
            result = (String)result + " after " + this.actions.toString().replaceAll("\\},", "\\};").replaceAll("\\[|\\]", "");
        }
        return result;
    }
}

