/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.query.syntax;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.grounding.GroundingRequirement;
import net.sf.tweety.action.grounding.GroundingTools;
import net.sf.tweety.action.query.syntax.ActionQuery;
import net.sf.tweety.action.query.syntax.QueryProposition;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.action.signature.FolAction;
import net.sf.tweety.commons.Signature;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.pl.syntax.Conjunction;
import net.sf.tweety.logics.pl.syntax.Disjunction;
import net.sf.tweety.logics.pl.syntax.Negation;
import net.sf.tweety.logics.pl.syntax.PlFormula;
import net.sf.tweety.logics.pl.syntax.Proposition;

public class SActionQuery
implements ActionQuery {
    protected PlFormula formula;
    protected Set<GroundingRequirement> requirements = new HashSet<GroundingRequirement>();

    public SActionQuery(PlFormula formula) {
        if (formula == null) {
            throw new NullPointerException();
        }
        for (Proposition p : formula.getAtoms()) {
            if (p instanceof QueryProposition) continue;
            throw new IllegalArgumentException("Invalid proposition in action query: has to be of type QueryProposition.");
        }
        this.formula = formula;
    }

    public SActionQuery(PlFormula formula, Set<GroundingRequirement> requirements) {
        this(formula);
        this.requirements.addAll(requirements);
    }

    public Signature getSignature() {
        return this.formula.getSignature();
    }

    public PlFormula getFormula() {
        return this.formula;
    }

    public ActionSignature getActionSignature() {
        ActionSignature s = new ActionSignature();
        for (Proposition p : this.formula.getAtoms()) {
            s.add((Object)((QueryProposition)p).getActionSignature());
        }
        return s;
    }

    public Set<FolFormula> getInnerFormulas() {
        HashSet<FolFormula> result = new HashSet<FolFormula>();
        for (Proposition p : this.formula.getAtoms()) {
            result.add(((QueryProposition)p).getInnerFormula());
        }
        return result;
    }

    public Set<FolAction> getInnerActions() {
        HashSet<FolAction> result = new HashSet<FolAction>();
        for (Proposition p : this.formula.getAtoms()) {
            result.addAll(((QueryProposition)p).getInnerActions());
        }
        return result;
    }

    public Set<FolAtom> getInnerAtoms() {
        HashSet<FolAtom> result = new HashSet<FolAtom>();
        for (Proposition p : this.formula.getAtoms()) {
            result.addAll(((QueryProposition)p).getInnerFormula().getAtoms());
            for (FolAction action : ((QueryProposition)p).getInnerActions()) {
                result.addAll(action.getAtoms());
            }
        }
        return result;
    }

    public Set<Variable> getInnerVariables() {
        HashSet<Variable> variables = new HashSet<Variable>();
        for (FolAtom a : this.getInnerAtoms()) {
            variables.addAll(a.getUnboundVariables());
        }
        return variables;
    }

    public Set<GroundingRequirement> getGroundingRequirements() {
        return new HashSet<GroundingRequirement>(this.requirements);
    }

    public Set<SActionQuery> getAllGrounded() {
        HashSet<SActionQuery> result = new HashSet<SActionQuery>();
        HashSet<Variable> variables = new HashSet<Variable>();
        for (FolAtom a : this.getInnerAtoms()) {
            variables.addAll(a.getUnboundVariables());
        }
        Set<Map<Variable, Constant>> substitutions = GroundingTools.getAllSubstitutions(variables);
        for (Map<Variable, Constant> map : substitutions) {
            if (!GroundingTools.isValidGroundingApplication(map, this.requirements)) continue;
            result.add(this.substituteInnerFormulas(map));
        }
        return result;
    }

    protected SActionQuery substituteInnerFormulas(Map<Variable, Constant> map) {
        return new SActionQuery(SActionQuery.substitutePropositions(map, this.formula), this.requirements);
    }

    private static PlFormula substitutePropositions(Map<Variable, Constant> map, PlFormula formula) {
        if (formula instanceof Conjunction) {
            Conjunction newMe = new Conjunction();
            for (PlFormula f : (Conjunction)formula) {
                newMe.add(SActionQuery.substitutePropositions(map, f));
            }
            return newMe;
        }
        if (formula instanceof Disjunction) {
            Disjunction newMe = new Disjunction();
            for (PlFormula f : (Disjunction)formula) {
                newMe.add(SActionQuery.substitutePropositions(map, f));
            }
            return newMe;
        }
        if (formula instanceof Negation) {
            return new Negation(SActionQuery.substitutePropositions(map, ((Negation)formula).getFormula()));
        }
        if (formula instanceof QueryProposition) {
            return ((QueryProposition)formula).substitute(map);
        }
        return formula;
    }

    public String toString() {
        String result = this.formula.toString();
        return result;
    }
}

