/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.signature;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.grounding.GroundingTools;
import net.sf.tweety.action.signature.FolActionName;
import net.sf.tweety.action.signature.FolFluentName;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Predicate;
import net.sf.tweety.logics.commons.syntax.Sort;
import net.sf.tweety.logics.commons.syntax.Variable;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolAtom;
import net.sf.tweety.logics.fol.syntax.FolFormula;
import net.sf.tweety.logics.fol.syntax.FolSignature;

public class ActionSignature
extends FolSignature {
    public ActionSignature() {
    }

    public ActionSignature(Collection<?> c) throws IllegalArgumentException {
        super(c);
    }

    public ActionSignature(FolFormula f) {
        if (f != null) {
            this.add(f);
        }
    }

    public Set<FolActionName> getActionNames() {
        HashSet<FolActionName> result = new HashSet<FolActionName>();
        for (Predicate a : this.getPredicates()) {
            if (!(a instanceof FolActionName)) continue;
            result.add((FolActionName)a);
        }
        return result;
    }

    public Set<FolFluentName> getFluentNames() {
        HashSet<FolFluentName> result = new HashSet<FolFluentName>();
        for (Predicate a : this.getPredicates()) {
            if (!(a instanceof FolFluentName)) continue;
            result.add((FolFluentName)a);
        }
        return result;
    }

    public boolean isValidFormula(Formula f) {
        if (!(f instanceof FolFormula)) {
            return false;
        }
        FolFormula fol = (FolFormula)f;
        for (Predicate a : fol.getPredicates()) {
            if (a instanceof FolActionName || a instanceof FolFluentName) continue;
            return false;
        }
        return !fol.containsQuantifier() && fol.getFunctors().isEmpty();
    }

    public String toString() {
        Object result = ":- signature\n";
        for (Sort s : this.getSorts()) {
            result = (String)result + s.getName() + " = " + s.getTerms(Constant.class).toString() + "\n";
        }
        for (FolActionName p : this.getActionNames()) {
            result = (String)result + p.toString() + "\n";
        }
        for (FolFluentName f : this.getFluentNames()) {
            result = (String)result + f.toString() + "\n";
        }
        return result;
    }

    public boolean containsActionName(String actionName) {
        return this.getActionName(actionName) != null;
    }

    public boolean containsFluentName(String fluentName) {
        return this.getFluentName(fluentName) != null;
    }

    public FolActionName getActionName(String action) {
        for (Predicate p : this.getPredicates()) {
            if (!(p instanceof FolActionName) || !((FolActionName)p).getName().equals(action)) continue;
            return (FolActionName)p;
        }
        return null;
    }

    public FolFluentName getFluentName(String fluentName) {
        for (Predicate p : this.getPredicates()) {
            if (!(p instanceof FolFluentName) || !((FolFluentName)p).getName().equals(fluentName)) continue;
            return (FolFluentName)p;
        }
        return null;
    }

    public boolean containsActionName(FolActionName actionName) {
        return this.getPredicates().contains(actionName);
    }

    public boolean containsFluentName(FolFluentName fluentName) {
        return this.getPredicates().contains(fluentName);
    }

    public boolean containsPredicate(Predicate predicate) {
        return this.getPredicates().contains(predicate);
    }

    public Set<FolAtom> getAllGroundedFluentAtoms() {
        HashSet<FolAtom> atoms = new HashSet<FolAtom>();
        HashSet<Variable> variables = new HashSet<Variable>();
        for (FolFluentName f : this.getFluentNames()) {
            FolAtom a = new FolAtom((Predicate)f);
            for (Sort s : f.getArgumentTypes()) {
                Variable v = new Variable("", s);
                a.addArgument((Term)v);
                variables.add(v);
            }
            atoms.add(a);
        }
        Set<Map<Variable, Constant>> substitutions = GroundingTools.getAllSubstitutions(variables);
        HashSet<FolAtom> result = new HashSet<FolAtom>();
        for (Map<Variable, Constant> substitution : substitutions) {
            for (FolAtom a : atoms) {
                result.add((FolAtom)a.substitute(substitution));
            }
        }
        return result;
    }

    public Set<FolAtom> getAllGroundedActionNameAtoms() {
        HashSet<FolAtom> atoms = new HashSet<FolAtom>();
        HashSet<Variable> variables = new HashSet<Variable>();
        for (FolActionName f : this.getActionNames()) {
            FolAtom a = new FolAtom((Predicate)f);
            for (Sort s : f.getArgumentTypes()) {
                Variable v = new Variable("", s);
                a.addArgument((Term)v);
                variables.add(v);
            }
            atoms.add(a);
        }
        Set<Map<Variable, Constant>> substitutions = GroundingTools.getAllSubstitutions(variables);
        HashSet<FolAtom> result = new HashSet<FolAtom>();
        for (Map<Variable, Constant> substitution : substitutions) {
            for (FolAtom a : atoms) {
                result.add((FolAtom)a.substitute(substitution));
            }
        }
        return result;
    }
}

