/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.signature;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.tweety.action.signature.ActionName;
import net.sf.tweety.action.signature.FolActionName;
import net.sf.tweety.logics.commons.syntax.interfaces.Term;
import net.sf.tweety.logics.fol.syntax.FolAtom;

public class FolAction
implements Iterable<FolAtom>,
ActionName {
    private Set<FolAtom> actionNames = new HashSet<FolAtom>();

    public FolAction() {
    }

    public FolAction(Set<FolAtom> actionNames) {
        for (FolAtom a : actionNames) {
            if (a.getPredicate() instanceof FolActionName) continue;
            throw new IllegalArgumentException("actionNames has to be a set of atoms with an ActionName predicate.");
        }
        this.actionNames.addAll(actionNames);
    }

    public Set<FolAtom> getAtoms() {
        HashSet<FolAtom> result = new HashSet<FolAtom>();
        result.addAll(this.actionNames);
        return result;
    }

    public String toString() {
        return this.actionNames.toString().replaceAll("\\[", "\\{").replaceAll("\\]", "\\}");
    }

    public FolAction substitute(Map<? extends Term<?>, ? extends Term<?>> map) {
        HashSet<FolAtom> result = new HashSet<FolAtom>();
        for (FolAtom a : this.actionNames) {
            result.add((FolAtom)a.substitute(map));
        }
        return new FolAction(result);
    }

    public boolean isGround() {
        for (FolAtom a : this.actionNames) {
            if (a.isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<FolAtom> iterator() {
        return Collections.unmodifiableCollection(this.actionNames).iterator();
    }

    @Override
    public String getName() {
        return this.toString();
    }
}

