/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.signature.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.action.signature.FolActionName;
import net.sf.tweety.action.signature.FolFluentName;
import net.sf.tweety.commons.ParserException;
import net.sf.tweety.logics.commons.syntax.Constant;
import net.sf.tweety.logics.commons.syntax.Sort;

public class ActionSignatureParser {
    private ActionSignature signature = new ActionSignature();

    public ActionSignature parseSignatureFromFile(String filename) throws FileNotFoundException, IOException, ParserException {
        return this.parseSignature(new InputStreamReader(new FileInputStream(filename)));
    }

    public ActionSignature parseSignature(String text) throws IOException, ParserException {
        return this.parseSignature(new StringReader(text));
    }

    public ActionSignature parseSignature(Reader reader) throws IOException, ParserException {
        Object s = "";
        try {
            int c;
            do {
                if ((c = reader.read()) == 10 || c == -1) {
                    if (!((String)s).equals("") && !((String)s).trim().startsWith("%")) {
                        String strim = ((String)s).trim();
                        if (strim.startsWith("fluent") || strim.startsWith("action")) {
                            this.parseTypeDeclaration(strim);
                        } else {
                            this.parseSortDeclaration(strim);
                        }
                    }
                    s = "";
                    continue;
                }
                s = (String)s + (char)c;
            } while (c != -1);
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
        return this.signature;
    }

    protected void parseSortDeclaration(String s) throws ParserException {
        String[] tokens;
        if (!s.contains("=")) {
            throw new ParserException("Missing '=' in sort declaration '" + s + "'.");
        }
        String sortname = s.substring(0, s.indexOf("=")).trim();
        if (!sortname.matches("[a-z,A-Z]([a-z,A-Z,0-9])*")) {
            throw new ParserException("Illegal characters in constant definition '" + sortname + "'; declartion must conform to [a-z,A-Z]([a-z,A-Z,0-9])*");
        }
        if (this.signature.containsSort(sortname)) {
            throw new ParserException("Multiple declarations of sort '" + sortname + "'.");
        }
        Sort theSort = new Sort(sortname);
        this.signature.add(theSort);
        if (!s.contains("{")) {
            throw new ParserException("Missing '{' in sort declaration '" + s + "',");
        }
        if (!s.contains("}")) {
            throw new ParserException("Missing '}' in sort declaration '" + s + "',");
        }
        String constants = s.substring(s.indexOf("{") + 1, s.lastIndexOf("}"));
        if (constants.contains("{")) {
            throw new ParserException("Multiple '{'s in sort declaration '" + s + "'.");
        }
        if (constants.contains("}")) {
            throw new ParserException("Multiple '}'s in sort declaration '" + s + "'.");
        }
        for (String token : tokens = constants.split(",")) {
            String c = token.trim();
            if (this.signature.containsConstant(c)) {
                throw new ParserException("Constant '" + c + "' has already been defined to be of sort '" + this.signature.getConstant(c).getSort() + "'.");
            }
            if (!c.matches("[a-z,A-Z]([a-z,A-Z,0-9])*")) {
                throw new ParserException("Illegal characters in constant definition '" + c + "'; declartion must conform to [a-z,A-Z]([a-z,A-Z,0-9])*");
            }
            this.signature.add(new Constant(c, theSort));
        }
    }

    protected void parseTypeDeclaration(String s) throws ParserException {
        boolean action;
        if (s.startsWith("action")) {
            action = true;
        } else if (s.startsWith("fluent")) {
            action = false;
        } else {
            throw new ParserException("Type declaration has to start either with 'action' or 'fluent'.");
        }
        String dec = s.substring(6).trim();
        if (!dec.contains("(")) {
            if (dec.contains(")")) {
                throw new ParserException("Dangling ')' in type declaration.");
            }
            String name = dec;
            if (!name.matches("[a-z,A-Z]([a-z,A-Z,0-9])*")) {
                throw new ParserException("Illegal characters in constant definition '" + name + "'; declartion must conform to [a-z,A-Z]([a-z,A-Z,0-9])*");
            }
            if (action) {
                this.signature.add(new FolActionName(name));
            } else {
                this.signature.add(new FolFluentName(name));
            }
        } else {
            if (!dec.contains(")")) {
                throw new ParserException("Missing ')' in type declaration.");
            }
            String name = dec.substring(0, dec.indexOf("(")).trim();
            if (!name.matches("[a-z,A-Z]([a-z,A-Z,0-9])*")) {
                throw new ParserException("Illegal characters in constant definition '" + name + "'; declartion must conform to [a-z,A-Z]([a-z,A-Z,0-9])*");
            }
            String sorts = dec.substring(dec.indexOf("(") + 1, dec.lastIndexOf(")"));
            if (sorts.trim().equals("")) {
                if (action) {
                    this.signature.add(new FolActionName(name));
                } else {
                    this.signature.add(new FolFluentName(name));
                }
                return;
            }
            String[] tokens = sorts.split(",");
            ArrayList<Sort> theSorts = new ArrayList<Sort>();
            for (String token : tokens) {
                String sort = token.trim();
                if (!this.signature.containsSort(sort)) {
                    throw new ParserException("Sort '" + sort + "' has not been declared before.");
                }
                theSorts.add(this.signature.getSort(sort));
            }
            if (action) {
                this.signature.add(new FolActionName(name, theSorts));
            } else {
                this.signature.add(new FolFluentName(name, theSorts));
            }
        }
    }
}

