/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.action.transitionsystem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.action.signature.ActionSignature;
import net.sf.tweety.action.signature.FolFluentName;
import net.sf.tweety.action.transitionsystem.State;
import net.sf.tweety.action.transitionsystem.Transition;
import net.sf.tweety.commons.util.Pair;
import net.sf.tweety.logics.fol.syntax.FolAtom;

public class TransitionSystem {
    private Set<State> states = new HashSet<State>();
    private Set<Transition> transitions = new HashSet<Transition>();
    private ActionSignature signature;

    public TransitionSystem(Set<State> states, Set<Transition> transitions, ActionSignature signature) {
        this.states.addAll(states);
        this.transitions.addAll(transitions);
        this.signature = signature;
    }

    public TransitionSystem(Set<State> states, ActionSignature signature) {
        this.states.addAll(states);
        this.signature = signature;
    }

    public TransitionSystem(ActionSignature signature) {
        this.signature = signature;
    }

    public State addState(Set<FolAtom> fluents) {
        State newState = this.getState(fluents);
        if (newState == null) {
            newState = new State(fluents);
            this.states.add(newState);
        }
        return newState;
    }

    public void addState(State s) {
        this.states.add(s);
    }

    public State getState(Set<FolAtom> fluents) {
        for (State s : this.states) {
            if (!s.getPositiveFluents().equals(fluents)) continue;
            return s;
        }
        return null;
    }

    public void addTransition(Transition t) {
        this.transitions.add(t);
    }

    public Set<State> getStates() {
        return new HashSet<State>(this.states);
    }

    public Set<Transition> getTransitions() {
        return new HashSet<Transition>(this.transitions);
    }

    public boolean getValue(FolAtom fluent, State state) {
        if (!(fluent.getPredicate() instanceof FolFluentName)) {
            throw new IllegalArgumentException("The atom '" + fluent + "' has to be a fluent.");
        }
        if (this.signature.containsFluentName((FolFluentName)fluent.getPredicate())) {
            return state.isMappedToTrue(fluent);
        }
        return false;
    }

    public String toDotFormat() {
        Object result = "digraph D {\n  rankdir=LR;\n";
        HashMap<String, Integer> statemap = new HashMap<String, Integer>();
        int i = 0;
        for (State s : this.states) {
            statemap.put(s.toString(), i);
            result = (String)result + "  " + i + " [label=\"";
            ++i;
            boolean first = true;
            for (FolAtom a : this.signature.getAllGroundedFluentAtoms()) {
                if (!first) {
                    result = (String)result + ",\\n";
                }
                first = false;
                result = s.isMappedToTrue(a) ? (String)result + a.toString() : (String)result + "-" + a.toString();
                result = (String)result;
            }
            result = (String)result + "\", shape=box];\n";
        }
        result = (String)result + "\n";
        HashMap<Pair, Object> transitionmap = new HashMap<Pair, Object>();
        for (Transition t : this.transitions) {
            Pair statepair = new Pair((Object)t.getFrom().toString(), (Object)t.getTo().toString());
            if (transitionmap.containsKey(statepair)) {
                transitionmap.put(statepair, (String)transitionmap.get(statepair) + "\\n" + t.getAction().toString());
                continue;
            }
            transitionmap.put(statepair, t.getAction().toString());
        }
        for (Pair statepair : transitionmap.keySet()) {
            result = (String)result + "  " + ((Integer)statemap.get(statepair.getFirst())).toString() + " -> ";
            result = (String)result + ((Integer)statemap.get(statepair.getSecond())).toString() + " [label=\"";
            result = (String)result + (String)transitionmap.get(statepair);
            result = (String)result + "\"]\n";
        }
        return (String)result + "}";
    }

    public ActionSignature getSignature() {
        return this.signature;
    }

    public String toString() {
        return " states: " + this.states.toString() + "\n transitions: " + this.transitions.toString();
    }
}

