/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.Signature;

public abstract class BeliefSet<T extends Formula, S extends Signature>
implements BeliefBase,
Collection<T> {
    public static final boolean EQUALS_USES_SIGNATURE = false;
    private Set<T> formulas;
    protected S signature;

    public BeliefSet() {
        this((S)new HashSet());
        this.signature = this.instantiateSignature();
    }

    public BeliefSet(Collection<? extends T> c) {
        this.signature = this.instantiateSignature();
        this.formulas = this.instantiateSet();
        this.addAll(c);
    }

    public BeliefSet(S sig) {
        this.signature = this.instantiateSignature(sig);
        this.formulas = this.instantiateSet();
    }

    protected Set<T> instantiateSet() {
        return new HashSet();
    }

    protected abstract S instantiateSignature();

    private S instantiateSignature(S sig) {
        try {
            return (S)((Signature)sig.getClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public S getSignature() {
        return (S)this.signature.clone();
    }

    public void setSignature(S sig) throws IllegalArgumentException {
        if (!this.signature.isSubSignature((Signature)sig)) {
            throw new IllegalArgumentException("The given signature is smaller than the signature of the belief base's formulas.");
        }
        this.signature = sig.clone();
    }

    @Override
    public boolean add(T f) {
        if (this.formulas.add(f)) {
            this.signature.add((Object)f);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(T ... formulas) {
        boolean result = true;
        for (T f : formulas) {
            boolean sub = this.add(f);
            result = result && sub;
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = true;
        for (Formula t : c) {
            boolean sub = this.add((T)t);
            result = result && sub;
        }
        return result;
    }

    @Override
    public void clear() {
        this.formulas.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.formulas.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.formulas.containsAll(c);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formulas == null ? 0 : this.formulas.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeliefSet other = (BeliefSet)obj;
        return !(this.formulas == null ? other.formulas != null : !this.formulas.equals(other.formulas));
    }

    @Override
    public boolean isEmpty() {
        return this.formulas.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.formulas.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.formulas.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = true;
        for (Object t : c) {
            boolean sub = this.remove(t);
            result = result && sub;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        HashSet<T> newFormulas = new HashSet<T>(this.formulas);
        for (T t : this) {
            if (c.contains(t)) continue;
            newFormulas.remove(t);
            result = true;
        }
        this.clear();
        this.addAll((Collection<? extends T>)newFormulas);
        return result;
    }

    @Override
    public int size() {
        return this.formulas.size();
    }

    @Override
    public Object[] toArray() {
        return this.formulas.toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.formulas.toArray(a);
    }

    @Override
    public String toString() {
        Object s = "{ ";
        Iterator<T> it = this.iterator();
        if (it.hasNext()) {
            s = (String)s + it.next();
        }
        while (it.hasNext()) {
            s = (String)s + ", " + it.next();
        }
        s = (String)s + " }";
        s = (String)s + "[Signature: " + this.signature + "]";
        return s;
    }
}

