/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.commons.Signature;

public abstract class DualSetSignature<T, S>
implements Signature {
    protected Set<T> firstSet;
    protected Set<S> secondSet;

    public DualSetSignature() {
        this.firstSet = new HashSet<T>();
        this.secondSet = new HashSet<S>();
    }

    public DualSetSignature(Set<T> args1, Set<S> args2) {
        this.firstSet = args1;
        this.secondSet = args2;
    }

    @Override
    public boolean isSubSignature(Signature other) {
        if (!(other instanceof DualSetSignature)) {
            return false;
        }
        DualSetSignature o = (DualSetSignature)other;
        if (!o.firstSet.containsAll(this.firstSet)) {
            return false;
        }
        return o.secondSet.containsAll(this.secondSet);
    }

    @Override
    public boolean isOverlappingSignature(Signature other) {
        if (!(other instanceof DualSetSignature)) {
            return false;
        }
        DualSetSignature o = (DualSetSignature)other;
        for (Object obj : o.firstSet) {
            if (!this.firstSet.contains(obj)) continue;
            return true;
        }
        for (Object obj : o.secondSet) {
            if (!this.secondSet.contains(obj)) continue;
            return true;
        }
        return true;
    }

    @Override
    public void addSignature(Signature other) {
        if (!(other instanceof DualSetSignature)) {
            return;
        }
        DualSetSignature sig = (DualSetSignature)other;
        this.firstSet.addAll(sig.firstSet);
        this.secondSet.addAll(sig.secondSet);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firstSet == null ? 0 : this.firstSet.hashCode());
        result = 31 * result + (this.secondSet == null ? 0 : this.secondSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DualSetSignature other = (DualSetSignature)obj;
        if (this.firstSet == null ? other.firstSet != null : !this.firstSet.equals(other.firstSet)) {
            return false;
        }
        return !(this.secondSet == null ? other.secondSet != null : !this.secondSet.equals(other.secondSet));
    }

    @Override
    public void addAll(Collection<?> c) {
        for (Object obj : c) {
            this.add(obj);
        }
    }

    @Override
    public void add(Object ... objects) throws IllegalArgumentException {
        for (Object f : objects) {
            this.add(f);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.firstSet.isEmpty() && this.secondSet.isEmpty();
    }

    @Override
    public void removeAll(Collection<?> c) {
        for (Object obj : c) {
            this.remove(obj);
        }
    }

    @Override
    public void clear() {
        this.firstSet = new HashSet<T>();
        this.secondSet = new HashSet<S>();
    }

    @Override
    public String toString() {
        return this.firstSet.toString() + ", " + this.secondSet.toString();
    }

    @Override
    public abstract DualSetSignature<T, S> clone();
}

