/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import net.sf.tweety.commons.BeliefBase;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.ParserException;

public abstract class Parser<T extends BeliefBase, S extends Formula> {
    public T parseBeliefBaseFromFile(String filename) throws FileNotFoundException, IOException, ParserException {
        InputStreamReader reader = new InputStreamReader(new FileInputStream(filename));
        T bs = this.parseBeliefBase(reader);
        reader.close();
        return bs;
    }

    public T parseBeliefBase(String text) throws IOException, ParserException {
        return this.parseBeliefBase(new StringReader(text));
    }

    public abstract T parseBeliefBase(Reader var1) throws IOException, ParserException;

    public S parseFormulaFromFile(String filename) throws FileNotFoundException, IOException, ParserException {
        InputStreamReader reader = new InputStreamReader(new FileInputStream(filename));
        S f = this.parseFormula(reader);
        reader.close();
        return f;
    }

    public S parseFormula(String text) throws IOException, ParserException {
        return this.parseFormula(new StringReader(text));
    }

    public abstract S parseFormula(Reader var1) throws IOException, ParserException;

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

