/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.tweety.commons.Signature;

public abstract class SingleSetSignature<T>
implements Signature,
Iterable<T> {
    protected Set<T> formulas;

    public SingleSetSignature() {
        this.formulas = new HashSet<T>();
    }

    public SingleSetSignature(Set<T> formulas) {
        this.formulas = formulas;
    }

    @Override
    public boolean isSubSignature(Signature other) {
        if (!(other instanceof SingleSetSignature)) {
            return false;
        }
        SingleSetSignature o = (SingleSetSignature)other;
        return o.formulas.containsAll(this.formulas);
    }

    @Override
    public boolean isOverlappingSignature(Signature other) {
        if (!(other instanceof SingleSetSignature)) {
            return false;
        }
        SingleSetSignature o = (SingleSetSignature)other;
        for (T obj : o.formulas) {
            if (!this.formulas.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addSignature(Signature other) {
        if (!(other instanceof SingleSetSignature)) {
            return;
        }
        SingleSetSignature sig = (SingleSetSignature)other;
        this.formulas.addAll(sig.formulas);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formulas == null ? 0 : this.formulas.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleSetSignature other = (SingleSetSignature)obj;
        return !(this.formulas == null ? other.formulas != null : !this.formulas.equals(other.formulas));
    }

    @Override
    public void addAll(Collection<?> c) {
        for (Object obj : c) {
            this.add(obj);
        }
    }

    @Override
    public void add(Object ... objects) throws IllegalArgumentException {
        for (Object f : objects) {
            this.add(f);
        }
    }

    @Override
    public void remove(Object o) {
        this.formulas.remove(o);
    }

    @Override
    public boolean isEmpty() {
        return this.formulas.isEmpty();
    }

    @Override
    public void removeAll(Collection<?> c) {
        for (Object obj : c) {
            this.remove(obj);
        }
    }

    public void retainAll(Collection<?> c) {
        HashSet<T> toBeRemoved = new HashSet<T>();
        for (T obj : this) {
            if (c.contains(obj)) continue;
            toBeRemoved.add(obj);
        }
        this.removeAll(toBeRemoved);
    }

    @Override
    public void clear() {
        this.formulas = new HashSet<T>();
    }

    @Override
    public Iterator<T> iterator() {
        return this.formulas.iterator();
    }

    @Override
    public String toString() {
        return this.formulas.toString();
    }

    public int size() {
        return this.formulas.size();
    }

    public boolean contains(T f) {
        return this.formulas.contains(f);
    }

    public boolean containsAll(Collection<T> c) {
        for (T f : c) {
            if (this.formulas.contains(f)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        return this.formulas.toArray();
    }

    public Collection<T> toCollection() {
        return this.formulas;
    }

    @Override
    public abstract SingleSetSignature<T> clone();
}

