/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.tweety.commons.Signature;

public abstract class TripleSetSignature<T, S, U>
implements Signature {
    protected Set<T> firstSet = new HashSet<T>();
    protected Set<S> secondSet = new HashSet<S>();
    protected Set<U> thirdSet = new HashSet<U>();

    @Override
    public boolean isSubSignature(Signature other) {
        if (!(other instanceof TripleSetSignature)) {
            return false;
        }
        TripleSetSignature o = (TripleSetSignature)other;
        if (!o.firstSet.containsAll(this.firstSet)) {
            return false;
        }
        if (!o.secondSet.containsAll(this.secondSet)) {
            return false;
        }
        return o.thirdSet.containsAll(this.thirdSet);
    }

    @Override
    public boolean isOverlappingSignature(Signature other) {
        if (!(other instanceof TripleSetSignature)) {
            return false;
        }
        TripleSetSignature o = (TripleSetSignature)other;
        for (Object obj : o.firstSet) {
            if (!this.firstSet.contains(obj)) continue;
            return true;
        }
        for (Object obj : o.secondSet) {
            if (!this.secondSet.contains(obj)) continue;
            return true;
        }
        for (Object obj : o.thirdSet) {
            if (!this.thirdSet.contains(obj)) continue;
            return true;
        }
        return true;
    }

    @Override
    public void addSignature(Signature other) {
        if (!(other instanceof TripleSetSignature)) {
            return;
        }
        TripleSetSignature sig = (TripleSetSignature)other;
        this.firstSet.addAll(sig.firstSet);
        this.secondSet.addAll(sig.secondSet);
        this.thirdSet.addAll(sig.thirdSet);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firstSet == null ? 0 : this.firstSet.hashCode());
        result = 31 * result + (this.secondSet == null ? 0 : this.secondSet.hashCode());
        result = 31 * result + (this.thirdSet == null ? 0 : this.thirdSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripleSetSignature other = (TripleSetSignature)obj;
        if (this.firstSet == null ? other.firstSet != null : !this.firstSet.equals(other.firstSet)) {
            return false;
        }
        if (this.secondSet == null ? other.secondSet != null : !this.secondSet.equals(other.secondSet)) {
            return false;
        }
        return !(this.thirdSet == null ? other.thirdSet != null : !this.thirdSet.equals(other.thirdSet));
    }

    @Override
    public void addAll(Collection<?> c) {
        for (Object obj : c) {
            this.add(obj);
        }
    }

    @Override
    public void add(Object ... objects) throws IllegalArgumentException {
        for (Object f : objects) {
            this.add(f);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.firstSet.isEmpty() && this.secondSet.isEmpty() && this.thirdSet.isEmpty();
    }

    @Override
    public void removeAll(Collection<?> c) {
        for (Object obj : c) {
            this.remove(obj);
        }
    }

    @Override
    public void clear() {
        this.firstSet = new HashSet<T>();
        this.secondSet = new HashSet<S>();
        this.thirdSet = new HashSet<U>();
    }

    @Override
    public String toString() {
        return this.firstSet.toString() + ", " + this.secondSet.toString() + ", " + this.thirdSet.toString();
    }

    @Override
    public abstract TripleSetSignature<T, S, U> clone();
}

