/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons;

public interface TweetyConfiguration {

    public static enum LogLevel {
        TRACE(5, "trace"),
        DEBUG(4, "debug"),
        INFO(3, "info"),
        WARN(2, "warn"),
        ERROR(1, "error"),
        FATAL(0, "fatal");

        private final int levelAsInt;
        private final String levelAsString;

        private LogLevel(int levelAsInt, String levelAsString) {
            this.levelAsInt = levelAsInt;
            this.levelAsString = levelAsString;
        }

        public int levelAsInt() {
            return this.levelAsInt;
        }

        public String levelAsString() {
            return this.levelAsString;
        }

        public static LogLevel getLogLevel(String s) {
            for (LogLevel l : LogLevel.values()) {
                if (l.levelAsString.equals(s.toLowerCase())) {
                    return l;
                }
                try {
                    if (l.levelAsInt != Integer.parseInt(s)) continue;
                    return l;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("The given string does not represent a log level.");
        }
    }
}

