/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.postulates;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.postulates.Postulate;
import net.sf.tweety.commons.postulates.PostulateEvaluatable;

public class PostulateEvaluationReport<S extends Formula> {
    private PostulateEvaluatable<S> ev;
    private Map<Postulate<S>, Collection<Collection<S>>> positiveInstances;
    private Map<Postulate<S>, Collection<Collection<S>>> notApplicableInstances;
    private Map<Postulate<S>, Collection<Collection<S>>> negativeInstances;

    public PostulateEvaluationReport(PostulateEvaluatable<S> ev, List<Postulate<S>> postulates) {
        this.ev = ev;
        this.positiveInstances = new HashMap<Postulate<S>, Collection<Collection<S>>>();
        this.negativeInstances = new HashMap<Postulate<S>, Collection<Collection<S>>>();
        this.notApplicableInstances = new HashMap<Postulate<S>, Collection<Collection<S>>>();
        for (Postulate<S> p : postulates) {
            this.positiveInstances.put(p, new LinkedList());
            this.negativeInstances.put(p, new LinkedList());
            this.notApplicableInstances.put(p, new LinkedList());
        }
    }

    public void addPositiveInstance(Postulate<S> postulate, Collection<S> instance) {
        this.positiveInstances.get(postulate).add(instance);
    }

    public void addNotApplicableInstance(Postulate<S> postulate, Collection<S> instance) {
        this.notApplicableInstances.get(postulate).add(instance);
    }

    public void addNegativeInstance(Postulate<S> postulate, Collection<S> instance) {
        this.negativeInstances.get(postulate).add(instance);
    }

    public Collection<Collection<S>> getNegativeInstances(Postulate<S> postulate) {
        if (this.negativeInstances.containsKey(postulate)) {
            return this.negativeInstances.get(postulate);
        }
        return new HashSet<Collection<S>>();
    }

    public String toString() {
        String result = "[" + this.ev.toString() + ":";
        for (Postulate<S> p : this.positiveInstances.keySet()) {
            result = result + p.getName() + "<" + this.positiveInstances.get(p).size() + "," + this.notApplicableInstances.get(p).size() + "," + this.negativeInstances.get(p).size() + ">;";
        }
        return result + "]";
    }

    public String prettyPrint() {
        int longest = 10;
        for (Postulate<S> p : this.positiveInstances.keySet()) {
            if (p.getName().length() <= longest) continue;
            longest = p.getName().length();
        }
        String result = this.ev.getClass().getSimpleName() + " RESULTS\n----------\n" + String.format("%-" + ++longest + "s%-13s%-14s%s", "Postulate ", "posInstances ", "notApplicable ", "negInstances\n");
        TreeMap<String, CallSite> ordered_postulate_strings = new TreeMap<String, CallSite>();
        for (Postulate<S> p : this.positiveInstances.keySet()) {
            String s = String.format("%-" + longest + "s%-13s%-14s%s", p.getName() + " ", this.positiveInstances.get(p).size(), this.notApplicableInstances.get(p).size(), this.negativeInstances.get(p).size()) + "\n";
            ordered_postulate_strings.put(p.getName(), (CallSite)((Object)s));
        }
        for (String s : ordered_postulate_strings.values()) {
            result = result + s;
        }
        return result;
    }
}

