/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.postulates;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.sf.tweety.commons.BeliefSet;
import net.sf.tweety.commons.BeliefSetIterator;
import net.sf.tweety.commons.Formula;
import net.sf.tweety.commons.postulates.Postulate;
import net.sf.tweety.commons.postulates.PostulateEvaluatable;
import net.sf.tweety.commons.postulates.PostulateEvaluationReport;

public class PostulateEvaluator<T extends Formula, U extends BeliefSet<T, ?>> {
    private BeliefSetIterator<T, U> iterator;
    private PostulateEvaluatable<T> ev;
    private List<Postulate<T>> postulates = new LinkedList<Postulate<T>>();

    public PostulateEvaluator(BeliefSetIterator<T, U> iterator, PostulateEvaluatable<T> ev, Collection<Postulate<T>> postulates) {
        this.iterator = iterator;
        this.ev = ev;
        this.postulates.addAll(postulates);
    }

    public PostulateEvaluator(BeliefSetIterator<T, U> iterator, PostulateEvaluatable<T> ev) {
        this.iterator = iterator;
        this.ev = ev;
    }

    public void addPostulate(Postulate<T> p) {
        this.postulates.add(p);
    }

    public void addAllPostulates(Collection<? extends Postulate<T>> postulates) {
        for (Postulate<T> p : postulates) {
            this.addPostulate(p);
        }
    }

    public boolean removePostulate(Postulate<T> p) {
        return this.postulates.remove(p);
    }

    public void removeAllPostulates(Collection<? extends Postulate<T>> postulates) {
        for (Postulate<T> p : postulates) {
            this.removePostulate(p);
        }
    }

    public PostulateEvaluationReport<T> evaluate(long num, boolean stopWhenFailed) {
        PostulateEvaluationReport<T> rep = new PostulateEvaluationReport<T>(this.ev, this.postulates);
        HashSet<Postulate<T>> failedPostulates = new HashSet<Postulate<T>>();
        int i = 0;
        while ((long)i < num) {
            Object instance = this.iterator.next();
            for (Postulate<T> postulate : this.postulates) {
                if (stopWhenFailed && failedPostulates.contains(postulate)) continue;
                if (!postulate.isApplicable((Collection<T>)instance)) {
                    rep.addNotApplicableInstance(postulate, (Collection<T>)instance);
                    continue;
                }
                if (postulate.isSatisfied((Collection<T>)instance, this.ev)) {
                    rep.addPositiveInstance(postulate, (Collection<T>)instance);
                    continue;
                }
                rep.addNegativeInstance(postulate, (Collection<T>)instance);
                failedPostulates.add(postulate);
            }
            ++i;
        }
        return rep;
    }

    public PostulateEvaluationReport<T> evaluate(long num) {
        return this.evaluate(num, true);
    }
}

