/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.tweety.commons.util.SubsetIterator;

public class DefaultSubsetIterator<T>
extends SubsetIterator<T> {
    private List<T> set;
    private BitSet currentItem;

    public DefaultSubsetIterator(Set<T> set) {
        super(set);
        this.set = new ArrayList<T>(set);
        this.currentItem = new BitSet(set.size());
    }

    @Override
    public boolean hasNext() {
        return this.currentItem != null;
    }

    @Override
    public Set<T> next() {
        if (this.currentItem == null) {
            throw new NoSuchElementException("No more elements");
        }
        HashSet<T> result = new HashSet<T>();
        for (int i = 0; i < this.set.size(); ++i) {
            if (this.currentItem.length() <= i || !this.currentItem.get(i)) continue;
            result.add(this.set.get(i));
        }
        this.currentItem = this.increment(this.currentItem);
        return result;
    }

    private BitSet increment(BitSet bitSet) {
        boolean carry = true;
        int i = 0;
        while (carry) {
            boolean tmp = carry;
            carry = carry && bitSet.get(i);
            bitSet.set(i, tmp ^ bitSet.get(i));
            ++i;
        }
        if (this.set.size() < i) {
            return null;
        }
        return bitSet;
    }
}

