/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.tweety.commons.util.SubsetIterator;

public class IncreasingSubsetIterator<T>
extends SubsetIterator<T> {
    private List<T> set;
    private int[] indices;
    private int currentSize;
    private boolean hasNext;

    public IncreasingSubsetIterator(Set<T> set) {
        super(set);
        this.set = new ArrayList<T>(set);
        this.indices = new int[set.size()];
        this.currentSize = 0;
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Set<T> next() {
        HashSet<T> result = new HashSet<T>();
        for (int i = 0; i < this.currentSize; ++i) {
            result.add(this.set.get(this.indices[i]));
        }
        if (this.currentSize != this.set.size()) {
            this.increment();
        } else {
            this.hasNext = false;
        }
        return result;
    }

    private void increment() {
        if (this.currentSize == 0) {
            this.currentSize = 1;
            this.indices[0] = 0;
        } else {
            this.increment(0);
        }
    }

    private int increment(int lvl) {
        if (lvl >= this.currentSize) {
            this.indices[lvl] = 0;
            ++this.currentSize;
        } else if (this.indices[lvl] < this.set.size() - lvl - 1) {
            int n = lvl;
            this.indices[n] = this.indices[n] + 1;
        } else {
            this.indices[lvl] = this.increment(lvl + 1) + 1;
        }
        return this.indices[lvl];
    }
}

