/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.tweety.commons.util.Pair;
import net.sf.tweety.commons.util.SetTools;

public class MapTools<E, F> {
    public Set<Map<E, F>> allMaps(Map<Set<E>, Set<F>> relations) {
        HashSet<Set<Set<Map<E, F>>>> maps = new HashSet<Set<Set<Map<E, F>>>>();
        for (Set<E> e : relations.keySet()) {
            maps.add(this.allMaps(e, relations.get(e)));
        }
        Set permutations = new SetTools<Set<Map<E, F>>>().permutations(maps);
        HashSet<Map<Map<E, F>, F>> result = new HashSet<Map<Map<E, F>, F>>();
        for (Set set : permutations) {
            result.add(this.combine(set));
        }
        return result;
    }

    public Set<Map<E, F>> allMapsSingleSource(Map<E, Set<F>> relations) {
        HashSet result = new HashSet();
        result.add(new HashMap());
        for (E key : relations.keySet()) {
            HashSet newResult = new HashSet();
            for (Map map : result) {
                for (F val : relations.get(key)) {
                    HashMap<E, F> newMap = new HashMap<E, F>(map);
                    newMap.put(key, val);
                    newResult.add(newMap);
                }
            }
            result = newResult;
        }
        return result;
    }

    public Set<Map<E, F>> allBijections(Collection<E> domain, Collection<F> range) {
        if (domain.size() != range.size()) {
            throw new IllegalArgumentException("Domain and range have to be of the same cardinality");
        }
        HashSet<Map<Map<Object, Object>, F>> result = new HashSet<Map<Map<Object, Object>, F>>();
        if (domain.size() == 1) {
            HashMap<E, F> newMap = new HashMap<E, F>();
            newMap.put(domain.iterator().next(), range.iterator().next());
            result.add(newMap);
            return result;
        }
        E elem = domain.iterator().next();
        HashSet<E> newDomain = new HashSet<E>(domain);
        newDomain.remove(elem);
        for (F elem2 : range) {
            HashSet<F> newRange = new HashSet<F>(range);
            newRange.remove(elem2);
            Set<Map<E, F>> subResult = this.allBijections(newDomain, newRange);
            for (Map<E, F> map : subResult) {
                map.put(elem, elem2);
                result.add(map);
            }
        }
        return result;
    }

    public Set<Map<E, F>> allMaps(Set<? extends E> domain, Set<? extends F> range) {
        HashSet<Map<Map, F>> allMaps = new HashSet<Map<Map, F>>();
        Stack stack = new Stack();
        Pair elem = new Pair();
        elem.setFirst(new HashMap());
        elem.setSecond(new Stack());
        ((Stack)elem.getSecond()).addAll(domain);
        stack.push(elem);
        while (!stack.isEmpty()) {
            elem = (Pair)stack.pop();
            if (((Stack)elem.getSecond()).isEmpty()) {
                allMaps.add((Map)elem.getFirst());
                continue;
            }
            Object domelem = ((Stack)elem.getSecond()).pop();
            for (F image : range) {
                HashMap newMap = new HashMap((Map)elem.getFirst());
                newMap.put(domelem, image);
                Stack newStack = new Stack();
                newStack.addAll((Collection)elem.getSecond());
                stack.push(new Pair(newMap, newStack));
            }
        }
        return allMaps;
    }

    public Map<E, F> combine(Set<Map<E, F>> singleMaps) throws IllegalArgumentException {
        HashMap<E, F> result = new HashMap<E, F>();
        for (Map<E, F> map : singleMaps) {
            for (E key : map.keySet()) {
                if (result.containsKey(key)) {
                    throw new IllegalArgumentException("Value of key " + key + " is ambiguous.");
                }
                result.put(key, map.get(key));
            }
        }
        return result;
    }

    public static boolean isInjective(Map<? extends Object, ? extends Object> map) {
        for (Object object : map.keySet()) {
            for (Object object2 : map.keySet()) {
                if (object == object2 || !map.get(object).equals(map.get(object2))) continue;
                return false;
            }
        }
        return true;
    }
}

