/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sf.tweety.commons.util.Shell;

public class NativeShell
extends Shell {
    NativeShell() {
    }

    @Override
    public String run(String cmd) throws InterruptedException, IOException {
        return NativeShell.invokeExecutable(cmd, -1L, true);
    }

    public static String invokeExecutable(String commandline) throws IOException, InterruptedException {
        return NativeShell.invokeExecutable(commandline, -1L);
    }

    public static String invokeExecutable(String commandline, long maxLines) throws IOException, InterruptedException {
        return NativeShell.invokeExecutable(commandline, maxLines, false);
    }

    public static String invokeExecutable(String commandline, long maxLines, boolean suppressErrors) throws IOException, InterruptedException {
        Process child = Runtime.getRuntime().exec(commandline);
        Object output = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(child.getInputStream()));
        String line = "";
        long lines = 0L;
        while ((line = reader.readLine()) != null) {
            output = (String)output + line + "\n";
            if (maxLines == -1L || ++lines < maxLines) continue;
        }
        reader.close();
        if (maxLines == -1L || lines < maxLines) {
            reader = new BufferedReader(new InputStreamReader(child.getErrorStream()));
            line = "";
            Object error = "";
            while ((line = reader.readLine()) != null) {
                error = (String)error + line + "\n";
            }
            reader.close();
            child.destroy();
            child.waitFor();
            ((String)error).trim();
            if (!suppressErrors && !((String)error).equals("")) {
                throw new IOException((String)error);
            }
            output = (String)output + (String)error;
        }
        return output;
    }
}

