/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.commons.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.sf.tweety.commons.util.SubsetIterator;

public class RandomSubsetIterator<T>
extends SubsetIterator<T> {
    private List<T> set;
    private boolean avoidDuplicates;
    private Random random;
    private Set<BitSet> temp;
    private long generatedSubsets;
    private double allSubsets;
    private boolean switched;

    public RandomSubsetIterator(Set<T> set, boolean avoidDuplicates) {
        super(set);
        this.set = new ArrayList<T>(set);
        this.avoidDuplicates = avoidDuplicates;
        this.random = new Random();
        if (this.avoidDuplicates) {
            this.temp = new HashSet<BitSet>();
            this.generatedSubsets = 0L;
            this.allSubsets = Math.pow(2.0, this.set.size());
            this.switched = false;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.avoidDuplicates || (double)this.generatedSubsets < this.allSubsets;
    }

    @Override
    public Set<T> next() {
        if (!this.avoidDuplicates) {
            HashSet<T> result = new HashSet<T>();
            for (T elem : this.set) {
                if (!this.random.nextBoolean()) continue;
                result.add(elem);
            }
            return result;
        }
        boolean firstHalf = this.generatedSubsets == 0L || this.allSubsets / (double)this.generatedSubsets > 2.0;
        BitSet bitSet = this.generate(this.set.size(), firstHalf);
        HashSet<T> result = new HashSet<T>();
        for (int i = 0; i < this.set.size(); ++i) {
            if (bitSet.length() <= i || !bitSet.get(i)) continue;
            result.add(this.set.get(i));
        }
        ++this.generatedSubsets;
        if (!this.switched && this.allSubsets / (double)this.generatedSubsets <= 2.0) {
            this.switched = true;
            HashSet<BitSet> temp2 = new HashSet<BitSet>();
            bitSet = new BitSet();
            double numberOfBitSets = Math.pow(2.0, this.set.size());
            long i = 0L;
            while ((double)i < numberOfBitSets) {
                if (!this.temp.contains(bitSet)) {
                    BitSet tmp = new BitSet();
                    tmp.or(bitSet);
                    temp2.add(tmp);
                }
                this.increment(bitSet);
                ++i;
            }
            this.temp = temp2;
        }
        return result;
    }

    private void increment(BitSet bitSet) {
        boolean carry = true;
        int i = 0;
        while (carry) {
            boolean tmp = carry;
            carry = carry && bitSet.get(i);
            bitSet.set(i, tmp ^ bitSet.get(i));
            ++i;
        }
    }

    private BitSet generate(int length, boolean checkForDuplicates) {
        if (checkForDuplicates) {
            BitSet result;
            while (this.temp.contains(result = this.generateRandomly(length))) {
            }
            this.temp.add(result);
            return result;
        }
        long idx = this.random.nextInt(this.temp.size());
        for (BitSet elem : this.temp) {
            if (idx == 0L) {
                this.temp.remove(elem);
                return elem;
            }
            --idx;
        }
        throw new RuntimeException("this should not happen");
    }

    private BitSet generateRandomly(int length) {
        BitSet result = new BitSet();
        for (int i = 0; i < length; ++i) {
            if (!this.random.nextBoolean()) continue;
            result.set(i);
        }
        return result;
    }
}

